/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.MutableRational;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableAffinTerm {
    TreeMap<LinVar, Rational> mSummands = new TreeMap();
    InfinitNumber mConstant = InfinitNumber.ZERO;

    public MutableAffinTerm add(Rational c) {
        this.mConstant = this.mConstant.add(new InfinitNumber(c, 0));
        return this;
    }

    public MutableAffinTerm add(InfinitNumber c) {
        this.mConstant = this.mConstant.add(c);
        return this;
    }

    public MutableAffinTerm add(Rational c, SharedTerm term) {
        if (c.equals(Rational.ZERO)) {
            return this;
        }
        if (term.getTerm() instanceof SMTAffineTerm) {
            this.add(c, term.getClausifier().createMutableAffinTerm(term));
        } else {
            this.addSimple(c, term.getLinVar());
        }
        return this;
    }

    public MutableAffinTerm add(Rational c, LinVar var) {
        if (c.equals(Rational.ZERO)) {
            return this;
        }
        if (var.isInitiallyBasic()) {
            for (Map.Entry<LinVar, BigInteger> me : var.getLinTerm().entrySet()) {
                this.add(c.mul(me.getValue()), me.getKey());
            }
        } else {
            this.addSimple(c, var);
        }
        return this;
    }

    private void addMap(Rational c, Map<LinVar, Rational> linterm) {
        for (Map.Entry<LinVar, Rational> summand : linterm.entrySet()) {
            this.addSimple(c.mul(summand.getValue()), summand.getKey());
        }
    }

    private void addSimple(Rational c, LinVar term) {
        assert (!c.equals(Rational.ZERO));
        Rational oldc = this.mSummands.remove(term);
        if (oldc != null && (c = oldc.add(c)).equals(Rational.ZERO)) {
            return;
        }
        this.mSummands.put(term, c);
    }

    public MutableAffinTerm add(Rational c, MutableAffinTerm a) {
        if (c != Rational.ZERO) {
            this.addMap(c, a.mSummands);
            this.mConstant = this.mConstant.add(a.mConstant.mul(c));
        }
        return this;
    }

    public MutableAffinTerm mul(Rational c) {
        if (c.equals(Rational.ZERO)) {
            this.mSummands.clear();
        } else if (!c.equals(Rational.ONE)) {
            for (Map.Entry<LinVar, Rational> summand : this.mSummands.entrySet()) {
                summand.setValue(c.mul(summand.getValue()));
            }
            this.mConstant = this.mConstant.mul(c);
        }
        return this;
    }

    public MutableAffinTerm div(Rational c) {
        return this.mul(c.inverse());
    }

    public MutableAffinTerm negate() {
        return this.mul(Rational.MONE);
    }

    public boolean isConstant() {
        return this.mSummands.isEmpty();
    }

    public InfinitNumber getConstant() {
        return this.mConstant;
    }

    public TreeMap<LinVar, Rational> getSummands() {
        return this.mSummands;
    }

    public Rational getGCD() {
        assert (!this.mSummands.isEmpty());
        Iterator<Rational> it = this.mSummands.values().iterator();
        Rational gcd = it.next();
        boolean firstSign = gcd.isNegative();
        gcd = gcd.abs();
        while (it.hasNext()) {
            gcd = gcd.gcd(it.next().abs());
        }
        if (firstSign) {
            gcd = gcd.negate();
        }
        return gcd;
    }

    void normalize() {
        this.mul(this.getGCD().inverse());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<LinVar, Rational> entry : this.mSummands.entrySet()) {
            LinVar var = entry.getKey();
            Rational fact = entry.getValue();
            if (fact.isNegative()) {
                sb.append(isFirst ? "-" : " - ");
            } else {
                sb.append(isFirst ? "" : " + ");
            }
            fact = fact.abs();
            if (!fact.equals(Rational.ONE)) {
                sb.append(fact).append('*');
            }
            sb.append(var);
            isFirst = false;
        }
        if (isFirst) {
            sb.append(this.mConstant);
        } else {
            int signum = this.mConstant.compareTo(InfinitNumber.ZERO);
            if (signum < 0) {
                sb.append(" - ");
                sb.append(this.mConstant.mul(Rational.MONE));
            } else if (signum > 0) {
                sb.append(" + ");
                sb.append(this.mConstant);
            }
        }
        return sb.toString();
    }

    public Sort getSort(Theory t) {
        return this.isInt() ? t.getSort("Int", new Sort[0]) : t.getSort("Real", new Sort[0]);
    }

    public Term toSMTLib(Theory t, boolean isInt, boolean quoted) {
        Sort numSort;
        Sort sort = numSort = isInt ? t.getSort("Int", new Sort[0]) : t.getSort("Real", new Sort[0]);
        assert (numSort != null);
        Sort[] binfunc = new Sort[]{numSort, numSort};
        FunctionSymbol times = t.getFunction("*", binfunc);
        FunctionSymbol plus = t.getFunction("+", binfunc);
        FunctionSymbol negate = t.getFunction("-", numSort);
        if (negate == null) {
            negate = t.getFunction("-", numSort);
        }
        assert (!isInt || this.mConstant.mA.isIntegral());
        Term constTerm = this.mConstant.mA.equals(Rational.ZERO) ? null : (isInt ? t.numeral(this.mConstant.mA.numerator()) : t.rational(this.mConstant.mA.numerator(), this.mConstant.mA.denominator()));
        Term[] terms = new Term[this.mSummands.size() + (constTerm == null ? 0 : 1)];
        if (constTerm != null) {
            terms[this.mSummands.size()] = constTerm;
        }
        int offset = 0;
        for (Map.Entry<LinVar, Rational> me : this.mSummands.entrySet()) {
            LinVar lv = me.getKey();
            Term convme = lv.getSharedTerm().getRealTerm();
            assert (!isInt || lv.isInt());
            assert (!isInt || me.getValue().isIntegral());
            if (!isInt && lv.isInt()) {
                Sort intSort = t.getSort("Int", new Sort[0]);
                FunctionSymbol toReal = t.getFunction("to_real", intSort);
                convme = t.term(toReal, convme);
            }
            if (me.getValue().equals(Rational.MONE)) {
                convme = t.term(negate, convme);
            } else if (!me.getValue().equals(Rational.ONE)) {
                Term convfac = isInt ? t.numeral(me.getValue().numerator()) : t.rational(me.getValue().numerator(), me.getValue().denominator());
                convme = t.term(times, convfac, convme);
            }
            terms[offset++] = convme;
        }
        if (terms.length == 0) {
            return isInt ? t.numeral(BigInteger.ZERO) : t.rational(BigInteger.ZERO, BigInteger.ONE);
        }
        if (terms.length == 1) {
            return terms[0];
        }
        return t.term(plus, terms);
    }

    public Rational getValue(LinArSolve linar) {
        assert (this.mConstant.mEps == 0);
        MutableRational val = new MutableRational(this.mConstant.mA);
        for (Map.Entry<LinVar, Rational> me : this.mSummands.entrySet()) {
            val.add(me.getValue().mul(linar.realValue(me.getKey())));
        }
        return val.toRational();
    }

    public boolean isInt() {
        for (LinVar v : this.mSummands.keySet()) {
            if (v.isInt()) continue;
            return false;
        }
        return true;
    }

    public Term toSMTLibLeq0(Theory smtTheory, boolean quoted) {
        assert (this.mConstant.mEps >= 0);
        if (this.isConstant()) {
            return this.mConstant.compareTo(InfinitNumber.ZERO) <= 0 ? smtTheory.mTrue : smtTheory.mFalse;
        }
        boolean isInt = this.isInt();
        String comp = this.mConstant.mEps == 0 ? "<=" : "<";
        Term zero = isInt ? smtTheory.numeral(BigInteger.ZERO) : smtTheory.decimal(BigDecimal.ZERO);
        ApplicationTerm res = smtTheory.term(comp, this.toSMTLib(smtTheory, isInt, quoted), zero);
        return quoted ? smtTheory.annotatedTerm(NamedAtom.QUOTED, res) : res;
    }
}

