/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;

public class FiniteSortInterpretation
implements SortInterpretation {
    private int mSize = 0;

    public Term toSMTLIB(Theory t, Sort sort) {
        TermVariable var = t.createTermVariable("@v", sort);
        Term[] disj = new Term[this.mSize];
        for (int i = 0; i < this.mSize; ++i) {
            disj[i] = t.equals(var, this.genModelTerm(i, t, sort));
        }
        return t.forall(new TermVariable[]{var}, t.or(disj));
    }

    public int ensureCapacity(int numValues) {
        if (this.mSize < numValues) {
            this.mSize = numValues;
        }
        return this.mSize;
    }

    public int size() {
        return this.mSize;
    }

    public Term get(int idx, Sort s, Theory t) throws IndexOutOfBoundsException {
        if (idx < 0 || idx >= this.mSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.genModelTerm(idx, t, s);
    }

    private Term genModelTerm(int idx, Theory t, Sort s) {
        return t.term(t.getFunctionWithResult("@" + idx, null, s, new Sort[0]), new Term[0]);
    }

    public int extendFresh() {
        return this.mSize++;
    }
}

