/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;

public class SharedTerm {
    private final Clausifier mClausifier;
    private final Term mTerm;
    private final IAnnotation mAnnot;
    CCTerm mCCterm;
    LinVar mLinVar;
    Rational mFactor;
    Rational mOffset;
    private Term mRealTerm = null;

    public SharedTerm(Clausifier clausifier, Term term) {
        this.mClausifier = clausifier;
        this.mTerm = term;
        this.mAnnot = clausifier.getEngine().isProofGenerationEnabled() ? this.mClausifier.getAnnotation() : null;
    }

    public void setLinVar(Rational factor, LinVar linvar, Rational offset) {
        this.mFactor = factor;
        this.mLinVar = linvar;
        this.mOffset = offset;
    }

    public void share() {
        if (this.mClausifier.getLogger().isInfoEnabled()) {
            this.mClausifier.getLogger().info("Sharing term: " + this);
        }
        assert (this.mCCterm != null && this.mOffset != null);
        this.mClausifier.getLASolver().share(this);
        this.mCCterm.share(this.mClausifier.getCClosure(), this);
    }

    public void shareWithLinAr() {
        if (this.mOffset != null) {
            return;
        }
        assert (this.getSort().isNumericSort()) : "Sharing non-numeric sort?";
        if (this.mTerm instanceof SMTAffineTerm) {
            this.mClausifier.getLASolver().generateSharedVar(this, this.mClausifier.createMutableAffinTerm((SMTAffineTerm)this.mTerm), this.mClausifier.getStackLevel());
        } else {
            boolean isint = this.getSort().getName().equals("Int");
            this.mLinVar = this.mClausifier.getLASolver().addVar(this, isint, this.mClausifier.getStackLevel());
            this.mFactor = Rational.ONE;
            this.mOffset = Rational.ZERO;
        }
        this.mClausifier.addUnshareLA(this);
        if (this.mCCterm != null) {
            this.share();
        }
    }

    public EqualityProxy createEquality(SharedTerm other) {
        return this.mClausifier.createEqualityProxy(this, other);
    }

    public void unshareLA() {
        this.mFactor = null;
        this.mLinVar = null;
        this.mOffset = null;
    }

    public void unshareCC() {
        this.mCCterm = null;
    }

    public LinVar getLinVar() {
        return this.mLinVar;
    }

    public Rational getOffset() {
        return this.mOffset;
    }

    public Rational getFactor() {
        return this.mFactor;
    }

    public boolean validShared() {
        return this.mCCterm != null && this.mOffset != null;
    }

    public Sort getSort() {
        return this.mTerm.getSort();
    }

    public Term getTerm() {
        return this.mTerm;
    }

    public Term getRealTerm() {
        if (this.mRealTerm == null) {
            this.mRealTerm = SMTAffineTerm.cleanup(this.mTerm);
        }
        return this.mRealTerm;
    }

    public IAnnotation getAnnotation() {
        return this.mAnnot;
    }

    public Clausifier getClausifier() {
        return this.mClausifier;
    }

    public CCTerm getCCTerm() {
        return this.mCCterm;
    }

    public int hashCode() {
        return this.mTerm.hashCode();
    }

    public String toString() {
        return SMTAffineTerm.cleanup(this.mTerm).toString();
    }

    void setCCTerm(CCTerm ccterm) {
        assert (this.mCCterm == null);
        this.mCCterm = ccterm;
        this.mClausifier.addUnshareCC(this);
        if (this.mOffset != null) {
            this.share();
        }
    }
}

