/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.InternAbstractTermWalker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;

public class OccurrenceCounter
extends NonRecursive {
    public void count(Term t) {
        this.run(new CountWalker(t));
    }

    public void reset(Term t) {
        this.run(new ResetWalker(t));
    }

    private static class ResetWalker
    extends InternAbstractTermWalker {
        public ResetWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive walker, SMTAffineTerm term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (term.mTmpCtr != 0) {
                for (Term t : term.getSummands().keySet()) {
                    occ.enqueueWalker(new ResetWalker(t));
                }
                term.mTmpCtr = 0;
            }
        }

        public void walk(NonRecursive walker, ConstantTerm term) {
        }

        public void walk(NonRecursive walker, AnnotatedTerm term) {
            walker.enqueueWalker(new ResetWalker(term.getSubterm()));
        }

        public void walk(NonRecursive walker, ApplicationTerm term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (term.mTmpCtr != 0) {
                for (Term t : term.getParameters()) {
                    occ.enqueueWalker(new ResetWalker(t));
                }
                term.mTmpCtr = 0;
            }
        }

        public void walk(NonRecursive walker, LetTerm term) {
            throw new InternalError("Term should be unletted before counting");
        }

        public void walk(NonRecursive walker, QuantifiedFormula term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (term.mTmpCtr != 0) {
                occ.enqueueWalker(new ResetWalker(term.getSubformula()));
                term.mTmpCtr = 0;
            }
        }

        public void walk(NonRecursive walker, TermVariable term) {
            term.mTmpCtr = 0;
        }
    }

    private static class CountWalker
    extends InternAbstractTermWalker {
        public CountWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive walker, SMTAffineTerm term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (++term.mTmpCtr == 1) {
                for (Term t : term.getSummands().keySet()) {
                    occ.enqueueWalker(new CountWalker(t));
                }
            }
        }

        public void walk(NonRecursive walker, ConstantTerm term) {
        }

        public void walk(NonRecursive walker, AnnotatedTerm term) {
            walker.enqueueWalker(new CountWalker(term.getSubterm()));
        }

        public void walk(NonRecursive walker, ApplicationTerm term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (++term.mTmpCtr == 1) {
                for (Term t : term.getParameters()) {
                    occ.enqueueWalker(new CountWalker(t));
                }
            }
        }

        public void walk(NonRecursive walker, LetTerm term) {
            throw new InternalError("Term should be unletted before counting");
        }

        public void walk(NonRecursive walker, QuantifiedFormula term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (++term.mTmpCtr == 1) {
                occ.enqueueWalker(new CountWalker(term.getSubformula()));
            }
        }

        public void walk(NonRecursive walker, TermVariable term) {
            ++term.mTmpCtr;
        }
    }
}

