/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sort {
    final SortSymbol mSymbol;
    final Sort[] mArgs;
    final BigInteger[] mIndices;
    Sort mRealSort;
    private int mHash;

    Sort(SortSymbol sym2, BigInteger[] indices, Sort[] args) {
        assert (args != null);
        assert (args.length == (sym2.isParametric() ? 0 : sym2.mNumParams)) : "Sort created with wrong number of args";
        this.mSymbol = sym2;
        this.mIndices = indices;
        this.mArgs = args;
        this.mHash = HashUtils.hashJenkins(this.mSymbol.hashCode(), this.mArgs);
        if (this.mIndices != null) {
            this.mHash = HashUtils.hashJenkins(this.mHash, this.mIndices);
        }
    }

    public String getName() {
        return this.mSymbol.getName();
    }

    public String getIndexedName() {
        String name = PrintTerm.quoteIdentifier(this.mSymbol.getName());
        if (this.mIndices == null) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(_ ").append(name);
        for (BigInteger i : this.mIndices) {
            sb.append(' ').append(i);
        }
        sb.append(')');
        return sb.toString();
    }

    public BigInteger[] getIndices() {
        return this.mIndices;
    }

    public Sort[] getArguments() {
        return this.mArgs;
    }

    public Sort getRealSort() {
        if (this.mRealSort == null) {
            if (this.mSymbol.mSortDefinition == null) {
                if (this.mArgs.length == 0) {
                    this.mRealSort = this;
                } else {
                    Sort[] newArgs = this.mArgs;
                    for (int i = 0; i < newArgs.length; ++i) {
                        Sort realArg = this.mArgs[i].getRealSort();
                        if (realArg == this.mArgs[i]) continue;
                        if (newArgs == this.mArgs) {
                            newArgs = (Sort[])this.mArgs.clone();
                        }
                        newArgs[i] = realArg;
                    }
                    this.mRealSort = newArgs == this.mArgs ? this : this.mSymbol.getSort(this.mIndices, newArgs).getRealSort();
                }
            } else {
                this.mRealSort = this.mSymbol.mSortDefinition.mapSort(this.mArgs).getRealSort();
            }
        }
        return this.mRealSort;
    }

    boolean equalsSort(Sort other) {
        if (this == other) {
            return true;
        }
        return this.getRealSort() == other.getRealSort();
    }

    boolean unifySort(HashMap<Sort, Sort> unifier, Sort concrete) {
        assert (concrete.getRealSort() == concrete);
        Sort last = unifier.get(this);
        if (last != null) {
            return last == concrete;
        }
        if (!this.mSymbol.isParametric()) {
            Sort me = this.getRealSort();
            if (me.mSymbol != concrete.mSymbol) {
                return false;
            }
            for (int i = 0; i < me.mArgs.length; ++i) {
                if (me.mArgs[i].unifySort(unifier, concrete.mArgs[i])) continue;
                return false;
            }
        }
        unifier.put(this, concrete);
        return true;
    }

    Sort mapSort(Sort[] substitution) {
        if (this.mSymbol.isParametric()) {
            return substitution[this.mSymbol.mNumParams];
        }
        if (this.mArgs.length == 0) {
            return this;
        }
        if (this.mArgs.length == 1) {
            Sort arg = this.mArgs[0].mapSort(substitution);
            return this.mSymbol.getSort(this.mIndices, arg);
        }
        HashMap<Sort, Sort> cachedMappings = new HashMap<Sort, Sort>();
        return this.mapSort(substitution, cachedMappings);
    }

    Sort mapSort(Sort[] substitution, HashMap<Sort, Sort> cachedMappings) {
        if (this.mSymbol.isParametric()) {
            return substitution[this.mSymbol.mNumParams];
        }
        Sort result = cachedMappings.get(this);
        if (result != null) {
            return result;
        }
        if (this.mArgs.length == 0) {
            result = this;
        } else {
            Sort[] newArgs = new Sort[this.mArgs.length];
            for (int i = 0; i < this.mArgs.length; ++i) {
                newArgs[i] = this.mArgs[i].mapSort(substitution, cachedMappings);
            }
            result = this.mSymbol.getSort(this.mIndices, newArgs);
        }
        cachedMappings.put(this, result);
        return result;
    }

    public boolean isParametric() {
        return this.mSymbol.isParametric();
    }

    public String toString() {
        if (this.mArgs.length == 0) {
            return this.getIndexedName();
        }
        StringBuilder sb = new StringBuilder();
        new PrintTerm().append((Appendable)sb, this);
        return sb.toString();
    }

    void toStringHelper(ArrayDeque<Object> m_Todo) {
        String name = this.getIndexedName();
        Sort[] args = this.getArguments();
        if (args.length == 0) {
            m_Todo.addLast(name);
        } else {
            m_Todo.addLast(")");
            for (int i = args.length - 1; i >= 0; --i) {
                m_Todo.addLast(args[i]);
                m_Todo.addLast(" ");
            }
            m_Todo.addLast(name);
            m_Todo.addLast("(");
        }
    }

    public Theory getTheory() {
        return this.mSymbol.mTheory;
    }

    public boolean isArraySort() {
        return this.getRealSort().mSymbol.isArray();
    }

    public boolean isNumericSort() {
        return this.getRealSort().mSymbol.isNumeric();
    }

    public boolean isInternal() {
        return this.mSymbol.isIntern();
    }

    public int hashCode() {
        return this.mHash;
    }
}

