/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermEquivalence;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FormulaLet
extends NonRecursive {
    private ArrayDeque<Map<Term, TermInfo>> mVisited;
    private ArrayDeque<Term> mResultStack;
    private int mCseNum;
    private LetFilter mFilter;

    public FormulaLet() {
        this(null);
    }

    public FormulaLet(LetFilter filter) {
        this.mFilter = filter;
    }

    public Term let(Term input) {
        input = new FormulaUnLet().unlet(input);
        this.mCseNum = 0;
        this.mVisited = new ArrayDeque();
        this.mResultStack = new ArrayDeque();
        this.run(new Letter(input));
        Term result = this.mResultStack.removeLast();
        assert (this.mResultStack.size() == 0 && this.mVisited.size() == 0);
        assert (new TermEquivalence().equal(new FormulaUnLet().unlet(result), input));
        this.mResultStack = null;
        this.mVisited = null;
        return result;
    }

    private static boolean isNamed(AnnotatedTerm at) {
        for (Annotation a : at.getAnnotations()) {
            if (!a.getKey().equals(":named")) continue;
            return true;
        }
        return false;
    }

    public Term[] getTerms(Term[] oldArgs) {
        Term[] newArgs = oldArgs;
        for (int i = oldArgs.length - 1; i >= 0; --i) {
            Term newTerm = this.mResultStack.removeLast();
            if (newTerm == oldArgs[i]) continue;
            if (newArgs == oldArgs) {
                newArgs = (Term[])oldArgs.clone();
            }
            newArgs[i] = newTerm;
        }
        return newArgs;
    }

    static class BuildAnnotatedTerm
    implements NonRecursive.Walker {
        final AnnotatedTerm mOldTerm;

        public BuildAnnotatedTerm(AnnotatedTerm term) {
            this.mOldTerm = term;
        }

        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term newBody = (Term)let.mResultStack.removeLast();
            Term result = this.mOldTerm;
            if (newBody != this.mOldTerm.getSubterm()) {
                Theory theory = this.mOldTerm.getTheory();
                result = theory.annotatedTerm(this.mOldTerm.getAnnotations(), newBody);
            }
            let.mResultStack.addLast(result);
        }
    }

    static class BuildQuantifier
    implements NonRecursive.Walker {
        final QuantifiedFormula mOldTerm;

        public BuildQuantifier(QuantifiedFormula term) {
            this.mOldTerm = term;
        }

        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term newBody = (Term)let.mResultStack.removeLast();
            Term result = this.mOldTerm;
            if (newBody != this.mOldTerm.getSubformula()) {
                Theory theory = this.mOldTerm.getTheory();
                result = this.mOldTerm.getQuantifier() == 0 ? theory.exists(this.mOldTerm.getVariables(), newBody) : theory.forall(this.mOldTerm.getVariables(), newBody);
            }
            let.mResultStack.addLast(result);
        }
    }

    static class BuildApplicationTerm
    implements NonRecursive.Walker {
        final ApplicationTerm mOldTerm;

        public BuildApplicationTerm(ApplicationTerm term) {
            this.mOldTerm = term;
        }

        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term[] newParams = let.getTerms(this.mOldTerm.getParameters());
            ApplicationTerm result = this.mOldTerm;
            if (newParams != this.mOldTerm.getParameters()) {
                Theory theory = this.mOldTerm.getTheory();
                result = theory.term(this.mOldTerm.getFunction(), newParams);
            }
            let.mResultStack.addLast(result);
        }
    }

    static class BuildLetTerm
    implements NonRecursive.Walker {
        final TermVariable[] mVars;

        public BuildLetTerm(TermVariable[] vars) {
            this.mVars = vars;
        }

        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term[] values = new Term[this.mVars.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = (Term)let.mResultStack.removeLast();
            }
            Term newBody = (Term)let.mResultStack.removeLast();
            Theory theory = newBody.getTheory();
            Term result = theory.let(this.mVars, values, newBody);
            let.mResultStack.addLast(result);
        }
    }

    static class BuildLet
    implements NonRecursive.Walker {
        final TermInfo mTermInfo;

        public BuildLet(TermInfo parent) {
            this.mTermInfo = parent;
        }

        public void walk(NonRecursive engine) {
            ArrayList<TermInfo> lettedTerms = this.mTermInfo.mLettedTerms;
            if (lettedTerms.isEmpty()) {
                return;
            }
            FormulaLet let = (FormulaLet)engine;
            TermVariable[] tvs = new TermVariable[lettedTerms.size()];
            let.enqueueWalker(this);
            let.enqueueWalker(new BuildLetTerm(tvs));
            int i = 0;
            for (TermInfo ti : lettedTerms) {
                tvs[i++] = ti.mSubst;
                let.enqueueWalker(new Transformer(ti, true));
            }
            lettedTerms.clear();
        }
    }

    static class Converter
    implements NonRecursive.Walker {
        TermInfo mParent;
        Term mTerm;
        boolean mIsCounted;

        public Converter(TermInfo parent, Term term, boolean isCounted) {
            this.mParent = parent;
            this.mTerm = term;
            this.mIsCounted = isCounted;
        }

        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term child = this.mTerm;
            TermInfo info = (TermInfo)((Map)let.mVisited.getLast()).get(child);
            if (info == null) {
                let.mResultStack.addLast(child);
                return;
            }
            info.mergeParent(this.mParent);
            if (info.shouldBuildLet() && info.mSubst == null && (let.mFilter == null || let.mFilter.isLettable(child))) {
                Term t = info.mTerm;
                info.mSubst = t.getTheory().createTermVariable(".cse" + let.mCseNum++, t.getSort());
            }
            if (this.mIsCounted && ++info.mSeen == info.mCount) {
                if (info.mSubst == null) {
                    let.enqueueWalker(new Transformer(info, true));
                } else {
                    TermInfo ancestor;
                    let.mResultStack.addLast(info.mSubst);
                    TermInfo letPos = ancestor = info.mParent;
                    while (ancestor != null && ancestor.mSubst == null) {
                        if (ancestor.mCount > 1) {
                            letPos = ancestor.mParent;
                        }
                        ancestor = ancestor.mParent;
                    }
                    letPos.mLettedTerms.add(info);
                }
                return;
            }
            if (info.mSubst == null) {
                let.enqueueWalker(new Transformer(info, false));
            } else {
                let.mResultStack.addLast(info.mSubst);
            }
        }
    }

    static class Transformer
    implements NonRecursive.Walker {
        TermInfo mTermInfo;
        boolean mIsCounted;

        public Transformer(TermInfo parent, boolean isCounted) {
            this.mTermInfo = parent;
            this.mIsCounted = isCounted;
        }

        public void walk(NonRecursive engine) {
            FormulaLet let = (FormulaLet)engine;
            Term term = this.mTermInfo.mTerm;
            if (this.mIsCounted) {
                let.enqueueWalker(new BuildLet(this.mTermInfo));
                this.mTermInfo.mLettedTerms = new ArrayList();
            }
            if (term instanceof QuantifiedFormula) {
                QuantifiedFormula quant = (QuantifiedFormula)term;
                let.enqueueWalker(new BuildQuantifier(quant));
                let.enqueueWalker(new Letter(quant.getSubformula()));
            } else if (term instanceof AnnotatedTerm) {
                AnnotatedTerm at = (AnnotatedTerm)term;
                let.enqueueWalker(new BuildAnnotatedTerm(at));
                if (FormulaLet.isNamed(at)) {
                    let.enqueueWalker(new Letter(at.getSubterm()));
                } else {
                    let.enqueueWalker(new Converter(this.mTermInfo, at.getSubterm(), this.mIsCounted));
                }
            } else if (term instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)term;
                let.enqueueWalker(new BuildApplicationTerm(appTerm));
                Term[] params = appTerm.getParameters();
                for (int i = params.length - 1; i >= 0; --i) {
                    let.enqueueWalker(new Converter(this.mTermInfo, params[i], this.mIsCounted));
                }
            } else {
                let.mResultStack.addLast(term);
            }
        }
    }

    private static final class TermInfo
    extends NonRecursive.TermWalker {
        int mCount = 1;
        int mSeen;
        ArrayList<TermInfo> mLettedTerms;
        TermVariable mSubst;
        TermInfo mParent;
        int mPDepth;

        public TermInfo(Term term) {
            super(term);
        }

        public boolean shouldBuildLet() {
            TermInfo info = this;
            while (info.mCount == 1) {
                info = info.mParent;
                if (info == null) {
                    return false;
                }
                if (info.mSubst == null) continue;
                return false;
            }
            return true;
        }

        public void mergeParent(TermInfo parent) {
            if (this.mParent == null) {
                this.mParent = parent;
                this.mPDepth = parent.mPDepth + 1;
                return;
            }
            while (this.mParent != parent) {
                if (parent.mPDepth == this.mParent.mPDepth) {
                    parent = parent.mParent;
                    this.mParent = this.mParent.mParent;
                    continue;
                }
                if (parent.mPDepth > this.mParent.mPDepth) {
                    parent = parent.mParent;
                    continue;
                }
                this.mParent = this.mParent.mParent;
            }
            this.mPDepth = this.mParent.mPDepth + 1;
        }

        public void walk(NonRecursive walker, ConstantTerm term) {
            throw new InternalError("No TermInfo for ConstantTerm allowed");
        }

        public void walk(NonRecursive walker, AnnotatedTerm term) {
            if (!FormulaLet.isNamed(term)) {
                this.visitChild((FormulaLet)walker, term.getSubterm());
            }
        }

        public void walk(NonRecursive walker, ApplicationTerm term) {
            Term[] args;
            for (Term t : args = term.getParameters()) {
                this.visitChild((FormulaLet)walker, t);
            }
        }

        public void walk(NonRecursive walker, LetTerm term) {
            throw new InternalError("Let-Terms should not be in the formula anymore");
        }

        public void walk(NonRecursive walker, QuantifiedFormula term) {
        }

        public void walk(NonRecursive walker, TermVariable term) {
            throw new InternalError("No TermInfo for TermVariable allowed");
        }

        public void visitChild(FormulaLet let, Term term) {
            if (term instanceof TermVariable || term instanceof ConstantTerm) {
                return;
            }
            if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getParameters().length == 0) {
                return;
            }
            TermInfo child = (TermInfo)((Map)let.mVisited.getLast()).get(term);
            if (child == null) {
                child = new TermInfo(term);
                ((Map)let.mVisited.getLast()).put(term, child);
                let.enqueueWalker(child);
            } else {
                ++child.mCount;
            }
        }
    }

    static class Letter
    implements NonRecursive.Walker {
        final Term mTerm;

        public Letter(Term term) {
            this.mTerm = term;
        }

        public void walk(NonRecursive engine) {
            if (this.mTerm instanceof TermVariable || this.mTerm instanceof ConstantTerm) {
                ((FormulaLet)engine).mResultStack.addLast(this.mTerm);
                return;
            }
            ((FormulaLet)engine).mVisited.addLast(new HashMap());
            TermInfo info = new TermInfo(this.mTerm);
            ((Map)((FormulaLet)engine).mVisited.getLast()).put(this.mTerm, info);
            engine.enqueueWalker(new NonRecursive.Walker(){

                public void walk(NonRecursive engine) {
                    ((FormulaLet)engine).mVisited.removeLast();
                }
            });
            engine.enqueueWalker(new Transformer(info, true));
            engine.enqueueWalker(info);
        }
    }

    public static interface LetFilter {
        public boolean isLettable(Term var1);
    }
}

