/*
 * Decompiled with CFR 0.152.
 */
package netmatch.qtool;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PNodeFilter;
import edu.umd.cs.piccolox.event.PSelectionEventHandler;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import netmatch.qtool.Network;
import netmatch.qtool.QEdge;
import netmatch.qtool.QElement;
import netmatch.qtool.QLoop;
import netmatch.qtool.QNode;
import netmatch.qtool.QPath;
import netmatch.qtool.QText;
import netmatch.qtool.QToolFrame;

public class QSelectHandler
extends PSelectionEventHandler
implements ActionListener {
    private JPopupMenu popup;
    private QElement popupElement;
    private PLayer nodeLayer;
    private PLayer edgeLayer;
    private JTextArea info;
    private QToolFrame frame;

    public QSelectHandler(PNode pNode, PNode pNodel, JTextArea info, QToolFrame frame) {
        super(pNode, pNodel);
        this.info = info;
        this.frame = frame;
        this.popup = new JPopupMenu();
        JMenuItem mItem = new JMenuItem("Edit Attribute...");
        mItem.addActionListener(this);
        this.popup.add(mItem);
        mItem = new JMenuItem("Delete");
        mItem.addActionListener(this);
        this.popup.add(mItem);
    }

    public void decorateSelectedNode(PNode node) {
        node.setPaint((Paint)QNode.SELECTED_NODE_COLOR);
        super.decorateSelectedNode(node);
    }

    public void undecorateSelectedNode(PNode node) {
        node.setPaint((Paint)QNode.NODE_COLOR);
        super.undecorateSelectedNode(node);
    }

    public void mousePressed(PInputEvent event) {
        super.mousePressed(event);
        this.checkPopup(event);
    }

    /*
     * WARNING - void declaration
     */
    public void mouseMoved(PInputEvent event) {
        void var2_2;
        QElement elem;
        super.mouseMoved(event);
        if (event.getPickedNode() instanceof QText) {
            elem = ((QText)event.getPickedNode()).getOwner();
        } else if (event.getPickedNode() instanceof QElement) {
            elem = (QElement)event.getPickedNode();
        } else {
            this.info.setText("");
            return;
        }
        this.info.setText(var2_2.getInfo());
    }

    public void mouseClicked(PInputEvent event) {
        super.mouseClicked(event);
        this.checkPopup(event);
    }

    public void mouseReleased(PInputEvent event) {
        super.mouseReleased(event);
        this.checkPopup(event);
    }

    private void checkPopup(PInputEvent event) {
        if (event.isPopupTrigger()) {
            Point2D pos = event.getPosition();
            int x = (int)pos.getX();
            int y = (int)pos.getY();
            if (event.getPickedNode() instanceof QText) {
                this.popupElement = ((QText)event.getPickedNode()).getOwner();
            } else {
                if (!(event.getPickedNode() instanceof QElement)) {
                    return;
                }
                this.popupElement = (QElement)event.getPickedNode();
            }
            this.nodeLayer = ((PCanvas)event.getComponent()).getCamera().getLayer(1);
            this.edgeLayer = ((PCanvas)event.getComponent()).getCamera().getLayer(0);
            Component c = (Component)event.getComponent();
            this.popup.show(c, x, y);
        }
    }

    public void keyPressed(PInputEvent event) {
    }

    protected void drag(PInputEvent e) {
        super.drag(e);
        Collection selectedNodes = this.getSelectionReference();
        Iterator it = selectedNodes.iterator();
        while (it.hasNext()) {
            PNode node = (PNode)it.next();
            if (!(node instanceof QNode)) continue;
            ((QNode)node).update();
        }
    }

    protected void startDrag(PInputEvent e) {
        super.startDrag(e);
    }

    public void select(PNode node) {
        if (node instanceof QText) {
            super.select((PNode)((QText)node).getOwner());
        } else {
            super.select(node);
        }
    }

    protected PNodeFilter createNodeFilter(PBounds bounds) {
        return new MyBoundsFilter(bounds);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Edit Attribute...")) {
            String oldLabel = this.popupElement.getAttr();
            String newLabel = JOptionPane.showInputDialog("Change attribute:", (Object)oldLabel);
            if (newLabel != null) {
                this.popupElement.setAttr(newLabel);
                this.frame.isModif = true;
                this.frame.setTitleModif();
            }
        } else if (command.equals("Delete")) {
            this.popupElement.delete(this.nodeLayer, this.edgeLayer);
            this.frame.isModif = true;
            this.frame.setTitleModif();
            if (this.popupElement instanceof QNode) {
                --Network.nCount;
            } else if (this.popupElement instanceof QLoop) {
                --Network.lCount;
            } else if (this.popupElement instanceof QEdge) {
                --Network.eCount;
            } else if (this.popupElement instanceof QPath) {
                --Network.pCount;
            }
            this.frame.updateStatus();
        }
    }

    protected class MyBoundsFilter
    extends PSelectionEventHandler.BoundsFilter {
        protected MyBoundsFilter(PBounds bounds) {
            super((PSelectionEventHandler)QSelectHandler.this, bounds);
        }

        public boolean accept(PNode node) {
            if (node instanceof QText) {
                return false;
            }
            return super.accept(node);
        }

        public boolean acceptChildrenOf(PNode node) {
            if (node instanceof QText) {
                return false;
            }
            return super.acceptChildrenOf(node);
        }

        public boolean isCameraLayer(PNode node) {
            return super.isCameraLayer(node);
        }
    }
}

