/*
 * Decompiled with CFR 0.152.
 */
package netmatch.qtool;

import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.util.PFixedWidthStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import netmatch.qtool.QElement;
import netmatch.qtool.QNode;

public class QPath
extends PPath
implements QElement {
    private static final Color PATH_COLOR = new Color(33, 33, 119);
    private static final float[] dash = new float[]{10.0f};
    private static final PFixedWidthStroke eStroke = new PFixedWidthStroke(2.0f, 0, 0, 10.0f, dash, 0.0f);
    private QNode source;
    private QNode target;
    private String attr = "?>0";
    private String id;
    private int valence = 0;

    public QPath(String id) {
        this.setStroke((Stroke)eStroke);
        this.setStrokePaint(PATH_COLOR);
        this.id = id;
    }

    public QPath(QNode s, QNode t, String id) {
        this.source = s;
        this.target = t;
        this.setStroke((Stroke)eStroke);
        this.setStrokePaint(PATH_COLOR);
        this.id = id;
        this.update();
    }

    public void delete(PLayer nodeLayer, PLayer edgeLayer) {
        if (this.getSource() != null) {
            this.getSource().removePath(this);
        }
        if (this.getTarget() != null) {
            this.getTarget().removePath(this);
        }
        edgeLayer.removeChild((PNode)this);
    }

    public String getInfo() {
        return "Path\nId: " + this.id + "\n" + "Attribute: " + this.attr + "\n" + "Source Id: " + this.getSource().getId() + "\n" + "Target Id: " + this.getTarget().getId() + "\n";
    }

    public String getId() {
        return this.id;
    }

    public void update() {
        QNode first = this.source;
        QNode second = this.target;
        float shift = 20.0f * (float)Math.floor((this.valence + 1) / 2);
        float sign = 1.0f;
        if (this.valence % 2 == 0) {
            sign = -1.0f;
        }
        if (this.target.getId().compareTo(this.source.getId()) < 0) {
            first = this.target;
            second = this.source;
        }
        Point2D start = first.getFullBoundsReference().getCenter2D();
        Point2D end = second.getFullBoundsReference().getCenter2D();
        this.reset();
        this.moveTo((float)start.getX(), (float)start.getY());
        if (this.valence > 0) {
            Point2D.Float point = new Point2D.Float((float)start.getX() + (float)(end.getX() - start.getX()) / 2.0f, (float)start.getY() + (float)(end.getY() - start.getY()) / 2.0f);
            double angle = Math.atan((end.getY() - start.getY()) / (end.getX() - start.getX()));
            if (end.getX() >= start.getX()) {
                point.setLocation(point.getX() + (double)(sign * shift) * Math.sin(angle), point.getY() - (double)(sign * shift) * Math.cos(angle));
            } else {
                point.setLocation(point.getX() - (double)(sign * shift) * Math.sin(angle), point.getY() + (double)(sign * shift) * Math.cos(angle));
            }
            this.lineTo((float)point.getX(), (float)point.getY());
        }
        this.lineTo((float)end.getX(), (float)end.getY());
    }

    void drawTo(Point2D end) {
        if (this.source == null) {
            return;
        }
        Point2D start = this.source.getFullBoundsReference().getCenter2D();
        this.reset();
        this.moveTo((float)start.getX(), (float)start.getY());
        this.lineTo((float)end.getX(), (float)end.getY());
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }

    public String getAttr() {
        return this.attr;
    }

    public QNode getSource() {
        return this.source;
    }

    public void setSource(QNode s) {
        this.source = s;
    }

    public QNode getTarget() {
        return this.target;
    }

    public void setTarget(QNode t) {
        this.target = t;
    }

    public void setValence(int newValence) {
        this.valence = newValence;
    }

    public int getValence() {
        return this.valence;
    }
}

