/*
 * Decompiled with CFR 0.152.
 */
package netmatch.qtool;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.event.PPanEventHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Paint;
import javax.swing.JTextArea;
import netmatch.qtool.QCreateEdgeHandler;
import netmatch.qtool.QCreateLoopHandler;
import netmatch.qtool.QCreateNodeHandler;
import netmatch.qtool.QCreatePathHandler;
import netmatch.qtool.QCreateStructure;
import netmatch.qtool.QSelectHandler;
import netmatch.qtool.QToolFrame;

public class QCanvas
extends PCanvas {
    static final Color BACKGROUND_COLOR = new Color(204, 204, 255);
    private final Cursor cursorHand = new Cursor(12);
    private final Cursor cursorDefault = new Cursor(0);
    private final QCreateNodeHandler createNodeHandler;
    private final QCreateEdgeHandler createEdgeHandler;
    private final QCreateLoopHandler createLoopHandler;
    private QCreatePathHandler createPathHandler;
    private QCreateStructure createStructure;
    private final PPanEventHandler panHandler = new PPanEventHandler();
    private QSelectHandler selectHandler;
    private int setup = -1;
    private PLayer nodeLayer;
    private PLayer edgeLayer;

    public QCanvas(QToolFrame frame, JTextArea info) {
        this.getCamera().setPaint((Paint)BACKGROUND_COLOR);
        this.createPathHandler = new QCreatePathHandler(frame);
        this.createNodeHandler = new QCreateNodeHandler(frame);
        this.createEdgeHandler = new QCreateEdgeHandler(frame);
        this.createLoopHandler = new QCreateLoopHandler(frame);
        this.createStructure = new QCreateStructure(frame);
        this.nodeLayer = this.getLayer();
        this.edgeLayer = new PLayer();
        this.getRoot().addChild((PNode)this.edgeLayer);
        this.getCamera().addLayer(0, this.edgeLayer);
        this.getCamera().addLayer(1, this.nodeLayer);
        this.edgeLayer.moveToFront();
        this.selectHandler = new QSelectHandler((PNode)this.nodeLayer, (PNode)this.nodeLayer, info, frame);
        this.setupSelectorMode();
    }

    public PLayer getNodeLayerReference() {
        return this.nodeLayer;
    }

    public PLayer getEdgeLayerReference() {
        return this.edgeLayer;
    }

    public void setupPathCreatorMode() {
        this.setCursor(this.cursorDefault);
        this.selectHandler.unselectAll();
        this.removeInputEventListener((PInputEventListener)this.createEdgeHandler);
        this.removeInputEventListener((PInputEventListener)this.createLoopHandler);
        this.removeInputEventListener((PInputEventListener)this.selectHandler);
        this.removeInputEventListener((PInputEventListener)this.createNodeHandler);
        this.removeInputEventListener((PInputEventListener)this.createStructure);
        this.removeInputEventListener((PInputEventListener)this.createPathHandler);
        this.addInputEventListener((PInputEventListener)this.createPathHandler);
        this.setPanEventHandler(null);
    }

    public void setupNodeCreatorMode() {
        this.setCursor(this.cursorDefault);
        this.selectHandler.unselectAll();
        this.removeInputEventListener((PInputEventListener)this.createEdgeHandler);
        this.removeInputEventListener((PInputEventListener)this.createLoopHandler);
        this.removeInputEventListener((PInputEventListener)this.selectHandler);
        this.removeInputEventListener((PInputEventListener)this.createPathHandler);
        this.removeInputEventListener((PInputEventListener)this.createStructure);
        this.removeInputEventListener((PInputEventListener)this.createNodeHandler);
        this.addInputEventListener((PInputEventListener)this.createNodeHandler);
        this.setPanEventHandler(null);
    }

    public void setupEdgeCreatorMode() {
        this.setCursor(this.cursorDefault);
        this.selectHandler.unselectAll();
        this.removeInputEventListener((PInputEventListener)this.createLoopHandler);
        this.removeInputEventListener((PInputEventListener)this.createNodeHandler);
        this.removeInputEventListener((PInputEventListener)this.selectHandler);
        this.removeInputEventListener((PInputEventListener)this.createPathHandler);
        this.removeInputEventListener((PInputEventListener)this.createStructure);
        this.removeInputEventListener((PInputEventListener)this.createEdgeHandler);
        this.addInputEventListener((PInputEventListener)this.createEdgeHandler);
        this.setPanEventHandler(null);
    }

    public void setupLoopCreatorMode() {
        this.setCursor(this.cursorDefault);
        this.selectHandler.unselectAll();
        this.removeInputEventListener((PInputEventListener)this.createNodeHandler);
        this.removeInputEventListener((PInputEventListener)this.selectHandler);
        this.removeInputEventListener((PInputEventListener)this.createEdgeHandler);
        this.removeInputEventListener((PInputEventListener)this.createPathHandler);
        this.removeInputEventListener((PInputEventListener)this.createStructure);
        this.removeInputEventListener((PInputEventListener)this.createLoopHandler);
        this.addInputEventListener((PInputEventListener)this.createLoopHandler);
        this.setPanEventHandler(null);
    }

    public void setupSelectorMode() {
        this.setCursor(this.cursorDefault);
        this.removeInputEventListener((PInputEventListener)this.createEdgeHandler);
        this.removeInputEventListener((PInputEventListener)this.createLoopHandler);
        this.removeInputEventListener((PInputEventListener)this.createNodeHandler);
        this.removeInputEventListener((PInputEventListener)this.createPathHandler);
        this.removeInputEventListener((PInputEventListener)this.createStructure);
        this.removeInputEventListener((PInputEventListener)this.selectHandler);
        this.addInputEventListener((PInputEventListener)this.selectHandler);
        this.setPanEventHandler(null);
    }

    public void setupMoveMode() {
        this.setCursor(this.cursorHand);
        this.selectHandler.unselectAll();
        this.removeInputEventListener((PInputEventListener)this.selectHandler);
        this.removeInputEventListener((PInputEventListener)this.createNodeHandler);
        this.removeInputEventListener((PInputEventListener)this.createLoopHandler);
        this.removeInputEventListener((PInputEventListener)this.createEdgeHandler);
        this.removeInputEventListener((PInputEventListener)this.createPathHandler);
        this.removeInputEventListener((PInputEventListener)this.createStructure);
        this.removeInputEventListener((PInputEventListener)this.panHandler);
        this.setPanEventHandler(this.panHandler);
    }

    public void setupStructure(int i) {
        this.setCursor(this.cursorDefault);
        this.selectHandler.unselectAll();
        this.removeInputEventListener((PInputEventListener)this.createEdgeHandler);
        this.removeInputEventListener((PInputEventListener)this.createLoopHandler);
        this.removeInputEventListener((PInputEventListener)this.selectHandler);
        this.removeInputEventListener((PInputEventListener)this.createPathHandler);
        this.removeInputEventListener((PInputEventListener)this.createNodeHandler);
        this.removeInputEventListener((PInputEventListener)this.createStructure);
        this.createStructure.setStructure(i);
        this.addInputEventListener((PInputEventListener)this.createStructure);
        this.setPanEventHandler(null);
    }
}

