/*
 * Decompiled with CFR 0.152.
 */
package netmatch.algorithm;

import netmatch.algorithm.AttrComparator;
import netmatch.algorithm.GraphLoader;
import netmatch.algorithm.netMatch;

public class Graph {
    private int n;
    private Object[] attr;
    private int[] in_count;
    private int[] out_count;
    private int[][] in;
    private int[][] out;
    private Object[][] in_attr;
    private Object[][] out_attr;
    AttrComparator node_comparator;
    AttrComparator edge_comparator;
    netMatch instance;
    private int[] networkID;

    public Graph(GraphLoader loader, netMatch instance) throws Exception {
        int j;
        int k;
        int i;
        this.instance = instance;
        this.node_comparator = null;
        this.edge_comparator = null;
        this.n = loader.NodeCount();
        this.attr = new Object[this.n];
        int v = 0;
        int size = 4 * this.n;
        for (i = 0; i < this.n; ++i) {
            this.attr[i] = loader.GetNodeAttr(i);
            instance.setPercentageComplete(++v * 100 / size);
            if (!instance.checkTask()) continue;
            return;
        }
        this.in_count = new int[this.n];
        this.out_count = new int[this.n];
        this.in = new int[this.n][];
        this.out = new int[this.n][];
        this.in_attr = new Object[this.n][];
        this.out_attr = new Object[this.n][];
        for (i = 0; i < this.n; ++i) {
            k = this.out_count[i] = loader.OutEdgeCount(i);
            this.out[i] = new int[k];
            this.out_attr[i] = new Object[k];
            for (j = 0; j < k; ++j) {
                int n2;
                this.out_attr[i][j] = new Object();
                int n = loader.GetOutEdge(i, j, this.out_attr);
                this.out[i][j] = n;
                int n3 = n2 = n;
                this.in_count[n3] = this.in_count[n3] + 1;
            }
            instance.setPercentageComplete(++v * 100 / size);
            if (!instance.checkTask()) continue;
            return;
        }
        for (i = 0; i < this.n; ++i) {
            k = this.in_count[i];
            this.in[i] = new int[k];
            this.in_attr[i] = new Object[k];
            int l = 0;
            for (j = 0; j < this.n; ++j) {
                if (!this.HasEdge(j, i)) continue;
                this.in[i][l] = j;
                this.in_attr[i][l] = this.GetEdgeAttr(j, i);
                ++l;
            }
            if (l != k) {
                throw new Exception();
            }
            instance.setPercentageComplete(++v * 100 / size);
            if (!instance.checkTask()) continue;
            return;
        }
        this.networkID = new int[this.n];
        for (i = 0; i < this.n; ++i) {
            this.networkID[i] = loader.getCyNetworkID(i);
            instance.setPercentageComplete(++v * 100 / size);
            if (!instance.checkTask()) continue;
            return;
        }
    }

    public void print() {
        int hj;
        int k;
        int ij;
        System.out.println("GRAPH");
        for (ij = 0; ij < this.attr.length; ++ij) {
            System.out.println("Node: " + ij + " " + this.attr[ij] + " incount:" + this.in_count[ij] + " outcount:" + this.out_count[ij]);
        }
        System.out.println("IN");
        for (ij = 0; ij < this.in_count.length; ++ij) {
            k = this.in_count[ij];
            for (hj = 0; hj < k; ++hj) {
                System.out.print(ij + "[" + this.in[ij][hj] + "," + this.in_attr[ij][hj] + "] ");
            }
            System.out.println();
        }
        System.out.println("OUT");
        for (ij = 0; ij < this.out_count.length; ++ij) {
            k = this.out_count[ij];
            for (hj = 0; hj < k; ++hj) {
                System.out.print(ij + "[" + this.out[ij][hj] + "," + this.out_attr[ij][hj] + "] ");
            }
            System.out.println();
        }
    }

    public void SetNodeComparator(AttrComparator comp) {
        this.node_comparator = comp;
    }

    public void SetEdgeComparator(AttrComparator comp) {
        this.edge_comparator = comp;
    }

    public boolean HasEdge(int n1, int n2, Object pattr) throws Exception {
        int[] id = this.out[n1];
        if (n1 < this.n && n2 < this.n) {
            int a = 0;
            int b = this.out_count[n1];
            while (a < b) {
                int c = a + b >> 1;
                if (id[c] < n2) {
                    a = c + 1;
                    continue;
                }
                if (id[c] > n2) {
                    b = c;
                    continue;
                }
                pattr = this.out_attr[n1][c];
                return true;
            }
            return false;
        }
        throw new Exception();
    }

    public int NodeCount() {
        return this.n;
    }

    public Object GetNodeAttr(int i) throws Exception {
        if (i < this.n) {
            return this.attr[i];
        }
        throw new Exception();
    }

    public int getCyNetworkID(int i) throws Exception {
        if (i < this.n) {
            return this.networkID[i];
        }
        throw new Exception();
    }

    public boolean HasEdge(int n1, int n2) throws Exception {
        return this.HasEdge(n1, n2, null);
    }

    public Object GetEdgeAttr(int n1, int n2) throws Exception {
        int[] id = this.out[n1];
        if (n1 < this.n && n2 < this.n) {
            int a = 0;
            int b = this.out_count[n1];
            while (a < b) {
                int c = a + b >> 1;
                if (id[c] < n2) {
                    a = c + 1;
                    continue;
                }
                if (id[c] > n2) {
                    b = c;
                    continue;
                }
                return this.out_attr[n1][c];
            }
            return null;
        }
        throw new Exception();
    }

    public int InEdgeCount(int node) throws Exception {
        if (node < this.n) {
            return this.in_count[node];
        }
        throw new Exception();
    }

    public int OutEdgeCount(int node) throws Exception {
        if (node < this.n) {
            return this.out_count[node];
        }
        throw new Exception();
    }

    public int GetInEdge(int node, int i) throws Exception {
        if (node < this.n && i < this.in_count[node]) {
            return this.in[node][i];
        }
        throw new Exception();
    }

    public int GetInEdge(int node, int i, Object pattr) throws Exception {
        if (node < this.n && i < this.in_count[node]) {
            pattr = this.in_attr[node][i];
            return this.in[node][i];
        }
        throw new Exception();
    }

    public Object GetInEdge2(int node, int i) throws Exception {
        if (node < this.n && i < this.in_count[node]) {
            return this.in_attr[node][i];
        }
        throw new Exception();
    }

    public int GetOutEdge(int node, int i) throws Exception {
        if (node < this.n && i < this.out_count[node]) {
            return this.out[node][i];
        }
        throw new Exception();
    }

    public int GetOutEdge(int node, int i, Object pattr) throws Exception {
        if (node < this.n && i < this.out_count[node]) {
            pattr = this.out_attr[node][i];
            return this.out[node][i];
        }
        throw new Exception();
    }

    public Object GetOutEdge2(int node, int i) throws Exception {
        if (node < this.n && i < this.out_count[node]) {
            return this.out_attr[node][i];
        }
        throw new Exception();
    }

    public boolean CompatibleNode(Object attr1, Object attr2) throws Exception {
        if (this.node_comparator == null) {
            return true;
        }
        return this.node_comparator.compatible(attr1, attr2);
    }

    public boolean CompatibleEdge(Object attr1, Object attr2) throws Exception {
        if (this.edge_comparator == null) {
            return true;
        }
        return this.edge_comparator.compatible(attr1, attr2);
    }
}

