#include "Reconstruction.h"
#include "Offline.h"
#include "grb.h"
#include "cfortran.h"
#include "hbook.h"
#include <time.h>

int grb_finder_backmap(int nBuffBack, PROB *prob, MAP *maps ) {

  double backnorm,start_time,end_time,backint,total;
  float  temp;
  int    iha,idec,dha,ddec,nhabins,xha,xdec,itotal;
  char   str[300];

  /* normalize background map */
  if (nBuffBack>0) {
    backnorm = 1./((float)nBuffBack);
  } else {
    backnorm = 0.;
  }

  start_time = clock();

  /* now bin background map */
  backint=0.;
  for (iha=NHA_BINS*1/4;iha<=NHA_BINS*3/4;iha++) {//450-1350:270-90 degrees
    for (idec=200;idec<=700;idec++) { //-20 to 80 degrees
      
      nhabins = prob->habins[idec];
      temp = ((float)maps->backmap_ha_dec[iha][idec])*backnorm;
      backint+=temp;

      for (dha=-nhabins;dha<=nhabins;dha++) {
        for (ddec=-SEARCHBIN;ddec<=SEARCHBIN;ddec++) {

          xha = iha+dha;

          if (xha<0)        { 
	    sprintf(str,"HA out of bounds\n",xha); xha+=NHA_BINS; 
	    grb_finder_logger(str);
	  }
          if (xha>NHA_BINS) { 
	    sprintf(str,"HA out of bounds\n",xha); xha-=NHA_BINS; 
	    grb_finder_logger(str);
	  }

          xdec = idec+ddec;

          if (xha>=NHA_BINS || xha<0) {
	    sprintf(str,"xha,xdec out of range: %d %d\n",xha,xdec);
	    grb_finder_logger(str);
	  }
	  
          maps->backmap[xha][xdec] += temp;
        }
      }
    }
  }
  
  sprintf(str,"Integral of Background map = %f\n",backint);
  grb_finder_logger(str);
  
  /* make index map for background */
  total = 0.; itotal=0;
  for (iha=NHA_BINS*1/4;iha<=NHA_BINS*3/4;iha++) {
    for (idec=0;idec<=NDEC_BINS;idec++) {
      if (maps->backmap[iha][idec]>0.) {
        temp = PROB_BINSF*(log(maps->backmap[iha][idec])-prob->minback)/prob->span;
      } else {
        temp = 0.;
      }
      if (temp<0.) temp =0.;
      if (temp>PROB_BINSF) temp=PROB_BINSF;
      maps->backmap_index[iha][idec] = (int)(temp+.5);
    }
  }
  end_time = clock();
  sprintf(str,"time to generate background map: %7.3fs\n",
          (double)(end_time - start_time)/(double)CLOCKS_PER_SEC);
  grb_finder_logger(str);

} 
