from __future__ import print_function #I added this because it made my life a lot easier when
#the 'end = ...' function was added in the print function that I didn't know a nice way to do
#in Python 2.7, so print statements must all have brackets in this version, no need in the server though
# Echo client program
import zmq
import random
import time
import os
import platform



# to act as a client
port = "50018"              # The server port
context = zmq.Context()
print ("Connecting to server...")
print("Hi you've reached Mark's client, how can we help you today?")
socket = context.socket(zmq.REQ)
socket.connect ("tcp://localhost:%s" % port)


# APPLICATION

partnerid = -1 # no partner
numberbidders = 0 # will be given by server
artists = ['Picasso', 'Rembrandt', 'Van_Gogh', 'Da_Vinci']

# DO SOMETHING HERE
# you need to change this to do something much more clever
'''
You have all the variables and lists you could need in the arguments of the function,
these will always be updated and relevant, so all you have to do is use them.
Write code to make your bot do a lot of smart stuff to beat all the other bots. Good luck,
and may the games begin!
'''

'''
itemsinauction is a list where at index "rd" the item in that round is being sold is displayed.

winnerarray is a list where at index "rd" the winner of the item sold in that round is displayed.

winneramount is a list where at index "rd" the amount of money paid for the item sold in that round is displayed.

example: I will now construct a sentence that would be correct if you substituted the outputs of the lists:
In round 5 winnerarray[4] bought itemsinauction[4] for winneramount[4] dirhams/dollars/money unit.

numberbidders is an integer displaying the amount of people playing the auction game.

players is a list containing all the names of the current players.

mybidderid is a string that contains your name.

artists is a list containing all the names of the artists (paintings) that are for sale in our auction.

standings is a set of nested dictionaries (standings is a dictionary that for each person has another dictionary
associated with them). standings[name][artist] will return how many paintings "artist" the player "name" currently has
standings[name]['money'] (remember quotes for string, important!) returns how much money the player "name" has left.
If you want to access information about yourself use standings[mybidderid][(name of artist)/'money']

rd is the current round in 0 based indexing.

Good luck!
'''
# The artist to bid on
bidOnArtist = None
def determinebid(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, round):
  global bidOnArtist
  currentItem = itemsinauction[round]
  bidAmount = 0
  # Wait until counter has reached X, 'wait' is used to break out of the loop if necessary
  wait = True
  while(round < 4 and wait): # This is much more dependent on just more than one competitor... and random number generation wins just as many times
    # In the event the first three items are the same, we'll bid on that artist
    if(itemsinauction[0] == itemsinauction[1] and itemsinauction[1] == itemsinauction[2]):
      wait = False
      bidOnArtist = str(itemsinauction[1])
      break
    for player in standings:
      # If anyone already has two paintings, break out of the loop and start going for those
      if(standings[player]['Picasso'] == 2):
        wait = False
        bidOnArtist = 'Picasso'
        break; # Break out of the while loop - bid on the paintings a player has two of because they'll have bid a lot of their money
      if(standings[player]['Rembrandt'] == 2):
        wait = False
        bidOnArtist = 'Rembrandt'
        break; # Break out of the while loop - bid on the paintings a player has two of because they'll have bid a lot of their money
      if(standings[player]['Van_Gogh'] == 2):
        wait = False
        bidOnArtist = 'Van_Gogh'
        break; # Break out of the while loop - bid on the paintings a player has two of because they'll have bid a lot of their money
      if(standings[player]['Da_Vinci'] == 2):
        wait = False
        bidOnArtist = 'Da_Vinci'
        break; # Break out of the while loop - bid on the paintings a player has two of because they'll have bid a lot of their money
        # TODO: In the case of this happening twice, bid on the painting which comes up first (or nah). Right now it happens on the last check, but is unlikely.
    print("Not bidding!")
    return 0 # Otherwise bid nothing because we're playing the p a t i e n c e g a m e
  print("Currently bidding on " + str(bidOnArtist))

  'Let the fun stuff begin! All of this stuff should just run ONCE- until bidOnArtist is defined'
  # Calculate which paintings other people have, similar to the while loop but I have to manipulate counters
  # I can pretty much count on people not having two paintings from more than one artist
  if(bidOnArtist == None): #Make sure the while loop didn't already decide this value
    playersWithPi = 0
    playersWithRe = 0
    playersWithVa = 0
    playersWithDa = 0
    for player in standings:
      # Whichever painting equals two, add it to the counters. Otherwise, one isn't enough to go off of.
      if(standings[player]['Picasso'] == 2):
        playersWithPi += 1
      elif(standings[player]['Rembrandt'] == 2):
        playersWithRe += 1
      elif(standings[player]['Van_Gogh'] == 2):
        playersWithVa += 1
      elif(standings[player]['Da_Vinci'] == 2):
        playersWithDa += 1
      
    if(playersWithPi == 0 and playersWithRe == 0 and playersWithVa == 0 and playersWithDa == 0):
      # Just in case no one has two paintings... go Da_Vinci!
      print("Hey! No players have two paintings.")
      # TODO: Calculate which artist comes up twice first, and go off of that
      playersWithDa = 2

      # Now that we have all of the counters, make the painting we want to bid on associated with the most competitive number that people have
      # WE ARE INDEED ASSUMING PEOPLE HAVE ALREADY BID... >:(
    if(playersWithPi > max(playersWithRe, playersWithVa, playersWithDa)): # Testing against the maximum
      bidOnArtist = 'Picasso'
    elif(playersWithRe > max(playersWithPi, playersWithVa, playersWithDa)):
      bidOnArtist = 'Rembrandt'
    elif(playersWithVa > max(playersWithRe, playersWithPi, playersWithDa)):
      bidOnArtist = 'Van_Gogh'
    elif(playersWithDa > max(playersWithRe, playersWithVa, playersWithPi)):
      bidOnArtist = 'Da_Vinci'
    else:
      # TODO: Find two that equal each other... otherwise, go Da_Vinci!
      bidOnArtist = 'Da_Vinci'
      print("Hey! You don't appear to have a max counter.")
  print("Currently bidding on " + str(bidOnArtist))
    
  'Now we calculate bids because we already know what artist we are going for'
  # Check if I should go all in
  if(standings[mybidderid][bidOnArtist] == 2):
    if(bidOnArtist == currentItem):
      bidAmount = moneyleft
  # Calculate your bid based on existing balances [represents how much left a player has to bid]
  maxBal = 0
  secondToMaxBal = 0
  for player in standings:
    if(player == mybidderid):
      continue
    if(standings[player]['money'] > maxBal):
      maxBal = standings[player]['money']
    elif(standings[player]['money'] > secondToMaxBal):
      secondToMaxBal = standings[player]['money']
  average = (maxBal + secondToMaxBal) / 2
  # If I don't have that same amount of money, bid 3/4 of what I have
  print("MAX BAL: " + str(maxBal))
  print("2-MAX BAL: " + str(secondToMaxBal))
  print("MY BAL: " + str(moneyleft))
  if(average > moneyleft):
    if(bidOnArtist == currentItem):
      bidAmount = int(moneyleft * .75)
  # Otherwise, bid the average plus the averaged average/maxBal
  else:
    if(bidOnArtist == currentItem):
      bidAmount = int(average)

  return bidAmount
''' ~END OF BID FUNCTION~ '''

mybidderid = input("Input team / player name: ").strip()  # this is the only thing that distinguishes the clients 
while len(mybidderid) == 0 or ' ' in mybidderid:
  mybidderid = input("You input an empty string or included a space in your name which is not allowed (_ or / are all allowed)\n for example Emil_And_Nischal is okay\nInput team / player name: ").strip()

moneyleft = 100 # should change over time
winnerarray = [] # who won each round
winneramount = [] # how much they paid

itemsinauction = []
myTypes = {'Picasso': 0, 'Rembrandt': 0, 'Van_Gogh': 0, 'Da_Vinci': 0, 'money': moneyleft}

# EXECUTION

# get list of items and types
getlistflag = 1
socket.send((str(mybidderid)).encode())
while(getlistflag == 1):
  data = socket.recv(5024)
  x = (data.decode("utf-8")).split(" ")
  # print "Have received response at ", str(mybidderid), " of: ", ' '.join(x)
  #Receives first how many players are in the game and then all 200 items in auction
  if(x[0] != "Not" and len(data) != 0):
    getlistflag = 0
    numberbidders = int(x[0])
    itemsinauction = x[1:]
  else:
    time.sleep(2)

while True:
  socket.send((str(mybidderid) + ' ').encode())
  data = socket.recv(5024)
  x = (data.decode("utf-8")).split(" ")
  #Wait until everyone has connected before bidding
  if (x[0] == 'wait'):
    continue
  #When everyone has connected the server knows all names
  #it can therefore transfer all the names after telling the client that it's ready
  players = []
  for player in range(1, numberbidders + 1):
    players.append(x[player])
  break
#Create initial standings for each player after everyone connected
standings = {name: {'Picasso': 0, 'Van_Gogh': 0, 'Rembrandt': 0, 'Da_Vinci': 0, 'money': 100} for name in players}
# now do bids
continueflag = 1
j = 0
if platform.system() == 'Windows':
  os.system('cls')
else:
  os.system('clear')
while(continueflag == 1):
  #roundStart = time.time()
  print(random.choice(["I'm doing my best, okay?", "Why aren't you cheering louder?", "Aren't you proud of me?", "Damn I'm good, and I don't even have a brain!", "And do you think you could do any better?", "I feel like it's me doing all the work, you're just chilling in your chair", "If I lose this it's your fault not mine... I'm doing EXACTLY what you told me to do!"]))
  print()
  bidflag = 1
  bid = determinebid(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, len(winnerarray))
  #sleep before sending the bid to make sure the server is ready, currently it's at a very big value 1
  #this should make it safe for any speed of computers or internet, but can probably be lower as I have had
  #it working on Wifi with my computer at 0.2
  time.sleep(1)
  socket.send((str(mybidderid) + " " + str(bid)).encode())
  while(bidflag == 1):
    # print "Have sent data from ", str(mybidderid)
    data = socket.recv(5024)
    x = (data.decode("utf-8")).split(" ")
    # print "Have received response at ", str(mybidderid), " of: ", ' '.join(x)
    if(x[0] != "Not"):
      bidflag = 0
    else:
      print("exception")
      time.sleep(2)


  resultflag = 1
  while(resultflag == 1):
    socket.send((str(mybidderid)).encode())
    # print "Have sent data from ", str(mybidderid)
    data = socket.recv(5024)
    x = (data.decode("utf-8")).split(" ")
    #Wait for all bids to be received
    if (x[0] == 'wait'):
      continue
    # print "Have received response at ", str(mybidderid), " of: ", ' '.join(x)
    #Check if the server told client that game is finished
    if len(x) >= 7 and x[7] == 'won.':
      time.sleep(5)
      continueflag = 0
      resultflag = 0
      print(data)
      print()
      print('game over')
    #Else update standings, winnerarray etc.
    if(x[0] != "ready") and (continueflag == 1):
      #roundLength = time.time()-roundStart
      #time.sleep(max(0, 5-roundLength))
      resultflag = 0
      if platform.system() == 'Windows':
        os.system('cls')
      else:
        os.system('clear')
      # print x
      winnerarray.append(x[0])
      winneramount.append(int(x[5]))
      standings[x[0]]['money'] -= int(x[5])
      standings[x[0]][x[3]] += 1
      if (x[0] == mybidderid):
        moneyleft -= int(x[5])
        myTypes[itemsinauction[j]] += 1
      # update moneyleft, winnerarray
    else:
      time.sleep(2)
  j+= 1
