from __future__ import print_function #I added this because it made my life a lot easier when
#the 'end = ...' function was added in the print function that I didn't know a nice way to do
#in Python 2.7, so print statements must all have brackets in this version, no need in the server though
# Echo client program
import zmq
import random
import time
import os
import platform



# to act as a client
port = "50018"# The server port
context = zmq.Context()
print ("Connecting to server...")
socket = context.socket(zmq.REQ)
socket.connect ("tcp://localhost:%s" % port)

# APPLICATION

partnerid = -1 # no partner
numberbidders = 0 # will be given by server
artists = ['Picasso', 'Rembrandt', 'Van_Gogh', 'Da_Vinci']

#remaps artists and players
remap_players={}
remap_artists={}

def determinebid(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, round_):
	'''
	itemsinauction <=> pieces
	winnerarray <=> history[i][0]
	winneramount <=> history[i][2]
	numberbidders <=> len(money)
	players ???
	mybidderid <~> player_id
	artists ???
	standings <~> map of accumulated[i][] + money
	'''
	def get_accumulated(player_id):
		#gets the subsection of standings belonging to remap_players[player_id]
		player_obj=standings[players[player_id]]
		#list comprehension:
		#converts {"Picasso": 1, "Van_Gogh": 2, "Rembrandt": 3, "Da_Vinci": 0}
		#	to [2, 0, 3, 1] if remap_artists={"Van_Gogh": 0, "Da_Vinci": 1, "Rembrandt": 2, "Picasso": 3}
		#returns [2, 0, 3, 1]
		return [player_obj[artists[i]] for i in range(len(artists))]

	if not round_:#implicit convert 0 to False and anything else to True
		#maps the str ids to proper ids
		for i in range(len(players)):
			remap_players[players[i]]=i
		for i in range(len(artists)):
			remap_artists[artists[i]]=i

	#accumulated [player_id] [pieces[curr_piece]]
	#separated by many spaces for explanation
	#  \/accumulated
	#  |                \/player_id
	#  |                |                            \/remap artist str to id
	#  |                |                            |              \/pieces
	#  |                |                            |              |              \/curr_piece
	if get_accumulated( remap_players[mybidderid] ) [remap_artists[ itemsinauction[round_] ]]>0:
		return 35
	#        \/runs a sum across a list
	#        |   \/see explanation above
	elif not sum(get_accumulated(remap_players[mybidderid])):#try to procure a piece, any piece will do
		return 30
	return 0#ignore everything else

# DATA

mybidderid = "overfitting_is_sad"

moneyleft = 100 # should change over time
winnerarray = [] # who won each round
winneramount = [] # how much they paid

itemsinauction = []
myTypes = {'Picasso': 0, 'Rembrandt': 0, 'Van_Gogh': 0, 'Da_Vinci': 0, 'money': moneyleft}

# EXECUTION

# get list of items and types
getlistflag = 1
socket.send((str(mybidderid)).encode())
while(getlistflag == 1):
	data = socket.recv(5024)
	x = (data.decode("utf-8")).split(" ")
	# print "Have received response at ", str(mybidderid), " of: ", ' '.join(x)
	#Receives first how many players are in the game and then all 200 items in auction
	if(x[0] != "Not" and len(data) != 0):
		getlistflag = 0
		numberbidders = int(x[0])
		itemsinauction = x[1:]
	else:
		time.sleep(2)

while True:
	socket.send((str(mybidderid) + ' ').encode())
	data = socket.recv(5024)
	x = (data.decode("utf-8")).split(" ")
	#Wait until everyone has connected before bidding
	if (x[0] == 'wait'):
		continue
	#When everyone has connected the server knows all names
	#it can therefore transfer all the names after telling the client that it's ready
	players = []
	for player in range(1, numberbidders + 1):
		players.append(x[player])
	break
#Create initial standings for each player after everyone connected
standings = {name: {'Picasso': 0, 'Van_Gogh': 0, 'Rembrandt': 0, 'Da_Vinci': 0, 'money': 100} for name in players}
# now do bids
continueflag = 1
j = 0
if platform.system() == 'Windows':
	os.system('cls')
else:
	os.system('clear')
while(continueflag == 1):
	#roundStart = time.time()
	##print(random.choice(["I'm doing my best, okay?", "Why aren't you cheering louder?", "Aren't you proud of me?", "Damn I'm good, and I don't even have a brain!", "And do you think you could do any better?", "I feel like it's me doing all the work, you're just chilling in your chair", "If I lose this it's your fault not mine... I'm doing EXACTLY what you told me to do!"]))
	##print()
	bidflag = 1
	bid = determinebid(itemsinauction, winnerarray, winneramount, numberbidders, players, mybidderid, artists, standings, len(winnerarray))
	#sleep before sending the bid to make sure the server is ready, currently it's at a very big value 1
	#this should make it safe for any speed of computers or internet, but can probably be lower as I have had
	#it working on Wifi with my computer at 0.2
	time.sleep(1)
	socket.send((str(mybidderid) + " " + str(bid)).encode())
	while(bidflag == 1):
		# print "Have sent data from ", str(mybidderid)
		data = socket.recv(5024)
		x = (data.decode("utf-8")).split(" ")
		# print "Have received response at ", str(mybidderid), " of: ", ' '.join(x)
		if(x[0] != "Not"):
			bidflag = 0
		else:
			print("exception")
			time.sleep(2)


	resultflag = 1
	while(resultflag == 1):
		socket.send((str(mybidderid)).encode())
		# print "Have sent data from ", str(mybidderid)
		data = socket.recv(5024)
		x = (data.decode("utf-8")).split(" ")
		#Wait for all bids to be received
		if (x[0] == 'wait'):
			continue
		# print "Have received response at ", str(mybidderid), " of: ", ' '.join(x)
		#Check if the server told client that game is finished
		if len(x) >= 7 and x[7] == 'won.':
			time.sleep(5)
			continueflag = 0
			resultflag = 0
			print(data)
			print()
			print('game over')
		#Else update standings, winnerarray etc.
		if(x[0] != "ready") and (continueflag == 1):
			#roundLength = time.time()-roundStart
			#time.sleep(max(0, 5-roundLength))
			resultflag = 0
			if platform.system() == 'Windows':
				os.system('cls')
			else:
				pass
				#os.system('clear')
			# print x
			winnerarray.append(x[0])
			winneramount.append(int(x[5]))
			standings[x[0]]['money'] -= int(x[5])
			standings[x[0]][x[3]] += 1
			if (x[0] == mybidderid):
				moneyleft -= int(x[5])
				myTypes[itemsinauction[j]] += 1
			# update moneyleft, winnerarray
		else:
			time.sleep(2)
	j+= 1


