#include "bitCube.h"


void set_node_other_levels(Node* root, int level)
{

	/* Allocate children nodes */
    int num_children=root->num_child();
	for(int t=0; t<num_children; t++){

		int val_child= root->get_child_in_pos(t)->get_val_dim();
		Node* node_child=root->get_child_in_pos(t);
		for(int h=val_child+1; h<n_dimensions; h++){

			Node* new_child= new Node();
			new_child->set_val_dim(h);
			new_child->set_level(level);
			node_child->insert_new_child(new_child);
		}
		set_node_other_levels(root->get_child_in_pos(t),level+1);
	}
	return;
}


/* Create BottomUpTree */
Node* make_BottomUpTree(int dim_value, int init_level)
{
	Node *root = new Node();

	/* Allocate Root */
	root->set_level(init_level);
	root->set_val_dim(dim_value);

	/* Allocate children of root node */
	for(int h=dim_value+1; h<n_dimensions; h++){

		Node* new_child= new Node();
		new_child->set_val_dim(h);
		new_child->set_level(init_level+1);
		root->insert_new_child(new_child);
	}
	set_node_other_levels(root, init_level+2);

	/* Return root of BottomUpTree */
	return root;
}


/* For each partition, load temporary bitmaps */
void load_bitmaps(int d, int index, int** data, int c)
{
	int ret, w, b, tmp_val, dim, byte_pos, i, g;
	  VALUE elem;

	(c % WORD_LEN)? dim=c/WORD_LEN+1: dim=c/WORD_LEN;

	for(int ind=init_area, array_pos=0; ind<=index; array_pos++)
	{
		for(byte_pos=0; byte_pos<WORD_LEN  && ind<=index; byte_pos++, ind++)
		{
			for(i=d+1; i<=n_dimensions-1; i++)
			{								
				tmp_val=data[i][ind];						

				/* First allocation. Nuova dimensione */
				if(!bitData[i].bitmaps[tmp_val].allocated)
				{					
					bitData[i].bitmaps[tmp_val].allocated=true;
					
					/****************************************
					 * Allocate first level bitmaps         *
					 * WORD ALIGNED HIBRID compression	    *
					 ****************************************/						
					bitData[i].bitmaps[tmp_val].map = new bitmap_rec(((n_tuples/card[i])/card[i])*2, array_pos, byte_pos);								

					/* Allocate second level bitmaps */
					if((i>=d+1) && (i<n_dimensions-1))
					{
						bitData[i].bitmaps[tmp_val].mapDim = new  bitmap_dim [n_dimensions-i-1];
						for(g=0; g<(n_dimensions-i-1); g++)
							bitData[i].bitmaps[tmp_val].mapDim[g].set_bitmap_dim(min(c,card[i+g+1]));
					}					

					elem.val=tmp_val;
					elem.count=1;
					bitData[i].bitmap_pos.push_back(elem);
						ret=bitData[i].bitmaps[tmp_val].pos = bitData[i].bitmap_pos.size()-1;	

				}

				/* Stessa Partizione. E' gi allocata. Bisogna per controllare
				 * sempre la dimensione della bitmap quando 
				 * si scrive.
				*/
				else if(bitData[i].bitmaps[tmp_val].pos!=-1)
				{								
					ret=bitData[i].bitmaps[tmp_val].pos;
					bitData[i].bitmap_pos[ret].count++;					
					bitData[i].bitmaps[tmp_val].map->set_bit_wah_without_F1(array_pos, byte_pos);					
				}

				/* Modify bitmaps size --> poich si tratta di 
				 * un elemento di un'altra partizione 				 
				*/
				else if(bitData[i].bitmaps[tmp_val].pos==-1)
				{				
					//Alloca mappa per la seconda dimensione					
					if((i>=d+1) && (i<n_dimensions-1))
						for(g=0; g<(n_dimensions-i-1); g++)
							bitData[i].bitmaps[tmp_val].mapDim[g].reset_bitmap_dim(min(c,card[i+g+1]));

					elem.val=tmp_val;
					elem.count=1;
					
					bitData[i].bitmap_pos.push_back(elem);
					ret=bitData[i].bitmaps[tmp_val].pos = bitData[i].bitmap_pos.size()-1;
					bitData[i].bitmaps[tmp_val].map->resize(((n_tuples/card[i])/card[i])*2,array_pos,byte_pos);

				}				
				pos[i]=tmp_val;
				w=ret/WORD_LEN;
				b=ret%WORD_LEN;
								
				/* Update second level bitmaps */
				for(int h=d+1; h<i; h++)
					bitData[h].bitmaps[pos[h]].mapDim[i-h-1].set_bit_dim(w, b, ret);				
			}
		}
	}
}


/* BottomUp Tree deallocation */
void delete_tree(Node* RootTree)
{
	for(int i=0; i<RootTree->num_child(); i++)
		delete_tree(RootTree->get_child_in_pos(i));	
	delete RootTree;
}


void delete_total_bitmaps(int d)
{
	for(int dimen=d+1; dimen<n_dimensions; dimen++)
	{
		for(int val=0; val<card[dimen]+1; val++)
		{
			if(bitData[dimen].bitmaps[val].allocated)
			{			
				delete bitData[dimen].bitmaps[val].map;
				
				if(dimen<n_dimensions-1)
					delete [] bitData[dimen].bitmaps[val].mapDim;
				bitData[dimen].bitmaps[val].allocated=false;
			}
		}
	}
}


void delete_mem(int** data)
{
	delete [] data[0];
	for(int d=1; d<n_dimensions; d++){
		delete [] data[d];
		delete [] bitData[d].bitmaps;
		delete n_uple_val[d].mapAND;
		delete n_uple_val[d].mapNodeDim;
	}
	delete [] data;
	delete [] bitData;
}

/*______________________________________________________________________
 | Main Procedures ******* BucBitmapDSC() and BucBitmapASC() **********	|
 | *** For each dimension, makes partitions and computes group-bys. ***	|
 |______________________________________________________________________|
*/

/* Run bitCubeD */
void bucBitmapDSC(int **data, int dim, int data_dim_size)
{
	clock_t init=clock();

	int **frequency, index, C, c, v, d, i;
	  Node* RootTree;

	// open data file
	if ((fo = fopen("bitCubeCom4.out", "w+")) == NULL) {
		printf("Error: cannot open file output.\n");
		exit(-1);
	}

	/* Initialization */
	frequency = new int*[n_dimensions];
	bitData = new cubeData[n_dimensions];
	n_uple_val.resize(n_dimensions);

	for (d = n_dimensions-1; d>=dim; d--)
	{
		
		dim_local=d;
		if(d>0)
		{
		    bitData[d].bitmaps = new vRecord[card[d]+1];
			for(int s=0; s<card[d]+1; s++)
			{
				bitData[d].bitmaps[s].pos = -1;		
				bitData[d].bitmaps[s].allocated = false;				
			}
			n_uple_val[d].mapNodeDim = new bitmap_dim(card[d]+1);		
			n_uple_val[d].mapAND = new bitmap_rec(2);			
		}		
		
		/* Find cardinality of dimension d */
		C= card[d]+1;

		/* Partition input data on dimension d */
		frequency[d] = new int[C];
		data = partition(data, d, C, frequency[d], data_dim_size);

		/* Create bitCubeTree for dimension d */
		if(d<(n_dimensions-1))
			RootTree=make_BottomUpTree(d,0);

		index = init_area= 0;
		for(v=0; v<n_dimensions; v++)
			n_uple_val[v].val=0;
	
		/* For each partition, make aggregations. */
		for (i = 1; i < C; i++)
		{			
			/* Frequency of dimension 'd', value 'i' */
			c = frequency[d][i];
			if(i==1)  index = c-1;
			else { init_area = index+1; index += c; }
			n_uple_val[d].val = data[d][init_area];							

			if(c<minSup) continue;
			for(v=0; v<n_dimensions; v++)
				n_uple_val[v].val==0?fprintf(fo,"* "):fprintf(fo,"%d ",n_uple_val[v].val);
			
			fprintf(fo,",%d\n",c);
			if(d==(n_dimensions-1)) continue;		
			
			/* Load bitmaps for local area */
			load_bitmaps(d, index, data, c);			
							
			/* Compute group-bys */
			compute_aggregates(RootTree, data);				

			for (int g=d+1; g<n_dimensions; g++)
				bitData[g].bitmap_pos.clear();										
		}

		/* Memory deallocation for dimension d */		
		delete_total_bitmaps(d);
		delete [] frequency[d];				

		if(d<(n_dimensions-1))
			delete_tree(RootTree);

		n_uple_val[d].val = 0;
	}

	/* Output 'ALL' group-by */
	for (d = dim; d < n_dimensions; d++)
		fprintf(fo,"* ");

    fprintf(fo,",%d",n_tuples);

	/* Get Computing Time */
	clock_t end=clock();
	printf("\nTime of Computing Cube: %.2f seconds",
	   (double)(end-init)/(double)CLOCKS_PER_SEC);

	/* Clean Up */
	delete_mem(data);
	delete [] frequency;
}


/* Read data from input file */
int** read_datafile(int **data, char *filename)
{
	FILE *f;
	int  i=0, j;
	char line[MAX_LINE_LENGTH], *word;

	// open data file
	if ((f = fopen(filename, "r")) == NULL) {
		printf("Error: cannot open file %s.\n", filename);
		exit(-1);
	}

	// read first line of data file
	fgets(line, MAX_LINE_LENGTH, f);

	// read in the number of tuples
	word = strtok(line, " ");
	n_tuples = atoi(word);

	n_dimensions = 0;
	word = strtok(NULL, " ");

	// count the number of dimensions
	while (word != NULL && (0 != strcmp(word, "\n"))) {

		card[n_dimensions]=atoi(word);
		(n_dimensions)++;
		word = strtok(NULL, "  ,\t");
	}

	n_uple_val.resize(n_dimensions);

	/* create appropriate sized array to hold  data */
	data= new int*[n_dimensions];
	for (i = 0; i < n_dimensions; i++)
		data[i] = new int[n_tuples];

	/* read in all data */
	i = j= 0;

	for (i = 0; i < n_tuples; i++) {

		// read a line
		fgets(line, MAX_LINE_LENGTH, f);
		word = strtok(line, ", ");

		for (j = 0; j < n_dimensions; j++) {

			data[j][i] = atoi(word);
			word = strtok(NULL, ", ");
		}
	}

	/* done with all file reading.  close data file */
	fclose(f);

	return data;
}





/* Make data partitions on dimension for bitCubeD */
int** partition(int **data, int dimension, int cardinality, int
		*frequency, int data_dim_size)
{
	int *counting_sort_freq = new int[cardinality],i,g;

	/* clear frequency */
	for (i = 0; i < cardinality; i++) frequency[i] = 0;

	/* calculate frequency */
	for ( i = 0; i < data_dim_size; i++)
		frequency[data[dimension][i]]++;

	/* make copy of frequency array for counting sort */
	counting_sort_freq = new int[cardinality];
	for (i = 0; i < cardinality; i++)
		counting_sort_freq[i] = frequency[i];

	/* add previous frequency count to current.  i.e.
	 * counting_sort_freq[i] will mean there are counting_sort_freq[i]
	 * numbers < i */
	for ( i = 1; i < cardinality; i++)
		counting_sort_freq[i] += counting_sort_freq[i - 1];

	/* allocate space for sorted results */
	int **sorted_data = new int*[n_dimensions];
	for(g=0; g<n_dimensions; g++)
		sorted_data[g] = new int[data_dim_size];

	/* counting sort */
	for (i = 0; i < data_dim_size; i++){

		for(g=0; g<n_dimensions; g++)
			sorted_data[g][counting_sort_freq[data[dimension][i]] - 1] = data[g][i];
		counting_sort_freq[data[dimension][i]]--;
	}

	/* clean up */
	delete[] data;
	delete[] counting_sort_freq;
	return sorted_data;
}


/********************************** COMPUTE AGGREGATES *********************************/


void print_t_upla(int val_dim, int val_aggr)
{
	for(int g=val_dim+1; g<n_dimensions; g++)
		fprintf(fo,"* ");
	fprintf(fo,",%d\n",val_aggr);
}

void printf_other_t_uple_n_data(string str, int val_dim, int num_elem, int** data)
{

	  int  row=n_uple_val[val_dim-1].record+init_area;
	  int  limit=2, y=0, pot=2, g;

	for(g=0; g<num_elem-1; g++)
		limit*=2;

	for(unsigned b=1; b<=limit-1; b++){

		fprintf(fo,str.c_str());
		if(b==pot) { y++; pot*=2; }

		for(g=0;  g<=y;  g++)
			(b & mask[g])? fprintf(fo,"%d ",data[val_dim+g][row]):fprintf(fo,"* ");

		for(; g<num_elem; g++)
			fprintf(fo,"* ");

		fprintf(fo,", 1\n");
	}
}

void printf_other_t_uple_n(string str, int val_dim)
{

	  int limit=2, y=0, pot=2, g;
	for(g=0; g<tmp_val.size()-1;g++)
		limit*=2;

	for(unsigned b=1; b<=limit-1; b++){

		fprintf(fo,str.c_str());
		if(b==pot) {y++; pot*=2; }
	
		for(g=0;  g<=y;  g++)
			(b & mask[g])? fprintf(fo,"%d ",tmp_val[g]):fprintf(fo,"* ");

		for(;g<tmp_val.size();g++)
			fprintf(fo," *");

		fprintf(fo,",1\n");
	}
}

string string_value(int val_dim)
{
	string str1;
	char str[50];

	n_uple_val[0].val==0?sprintf(str,"* "):sprintf(str,"%d ",n_uple_val[0].val);
	str1.assign(str);

	for(int i=1; i<val_dim; i++){
		n_uple_val[i].val==0?sprintf(str,"* "):sprintf(str,"%d ",n_uple_val[i].val);
		str1.append(str);
	}
	return str1;
}

/* Case 1-2-3. Level 1 */
void case_level_one(Node* child, int** data)
{
	char tmp[MAX_STRING_LEN];
	string tmp_st;
	int val_dim=child->get_val_dim();
	  vector<VALUE>::iterator iter=bitData[val_dim].bitmap_pos.begin();	
	bool flag=0;

	//Compute previous value
	string str_v=string_value(val_dim);

	switch(child->num_child()){

	/* No child */
	case 0:
	{
		//Aggregate pairs 
		for(int i=0;iter!=bitData[val_dim].bitmap_pos.end(); iter++, i++){

			/* Iceberg condition */
			if(iter->count>=minSup){
				fprintf(fo,"%s%d ,%d\n",str_v.c_str(),iter->val,iter->count);
			}			
			bitData[val_dim].bitmaps[iter->val].pos = -1;
		}		
		return;
	}//case 0

	/* One child */
	case 1:
	{
		int child_dim = val_dim+1, indice = 0, val_count = 0;		
		if(child_dim-dim_local==2) flag=1;			

		for(int i=0; iter!=bitData[val_dim].bitmap_pos.end(); iter++, i++){

			if(iter->count<minSup){
				//upper_bit[val_dim]->set_bit_to_0(i/WORD_LEN,i%WORD_LEN);			
				goto exit_level_1;
			}			
			sprintf(tmp,"%d ",iter->val);
			tmp_st=str_v + tmp;
			fprintf(fo,"%s* ,%d\n",tmp_st.c_str(),iter->count);			
			
			if(iter->count==1){

				/* direct aggregation */
				fprintf(fo,"%s%d ,1\n",tmp_st.c_str(),bitData[child_dim].bitmap_pos
						[bitData[val_dim].bitmaps[iter->val].mapDim[indice].get_last_bit()].val);
			}
			else{

				int  ret, i, j, ret_val;

				int init_bit = bitData[val_dim].bitmaps[iter->val].mapDim[indice].get_current_bit();
				int end_bit = bitData[val_dim].bitmaps[iter->val].mapDim[indice].get_last_bit();

				int c_word = init_bit/WORD_LEN;
				int c_end = end_bit/WORD_LEN;				

				n_uple_val[val_dim].val = iter->val;

				/* Filtra con le mappe globali */
				bitData[val_dim].bitmaps[iter->val].mapDim[indice].
						make_and(upper_bit[child_dim]->ret_bit_dimAll(),
						c_word, c_end);

				if(c_word==c_end)
				{
					for(j=init_bit%WORD_LEN, ret=init_bit; j<=end_bit%WORD_LEN; j++, ret++)
					{
						if(bitData[val_dim].bitmaps[iter->val].mapDim[indice].get_bit(c_word,j))
						{
							if (flag)
								ret_val=bitData[val_dim].bitmaps[iter->val].map->make_and_two_without_mem_and_F1_sorted
												(bitData[child_dim].bitmaps[bitData[child_dim].bitmap_pos[ret].val].map);
							
								else ret_val=bitData[val_dim].bitmaps[iter->val].map->make_and_two_without_mem_and_F1
												(bitData[child_dim].bitmaps[bitData[child_dim].bitmap_pos[ret].val].map);								
								
								//controllo il conteggio
								if(ret_val>=minSup)								
									fprintf(fo,"%s%d ,%d\n",tmp_st.c_str(),bitData[child_dim].bitmap_pos[ret].val,ret_val);								
								else bitData[val_dim].bitmaps[iter->val].mapDim[indice].set_bit_to_0(c_word,j);
						}
					}				
					goto exit_level_1;
				}

				for(i=c_word, ret=c_word*WORD_LEN; i<=c_end; i++)
				{
					if(bitData[val_dim].bitmaps[iter->val].mapDim[indice].check_word(i))
					{
						for(j=0; j<WORD_LEN; j++, ret++){
							if(bitData[val_dim].bitmaps[iter->val].mapDim[indice].get_bit(i,j)){
								
								if(flag)
									ret_val=bitData[val_dim].bitmaps[iter->val].map->make_and_two_without_mem_and_F1_sorted
											(bitData[child_dim].
											bitmaps[bitData[child_dim].
											bitmap_pos[ret].
											val].map);

									else ret_val=bitData[val_dim].bitmaps[iter->val].map->make_and_two_without_mem_and_F1
											(bitData[child_dim].
											bitmaps[bitData[child_dim].
											bitmap_pos[ret].
											val].map);								
									
																	
									//controllo il conteggio
									if(ret_val>=minSup){
											fprintf(fo,"%s%d ,%d\n",tmp_st.c_str(),
												bitData[child_dim].bitmap_pos[ret].val,ret_val);											
									}
									else bitData[val_dim].bitmaps[iter->val].mapDim[indice].set_bit_to_0(i,j);
									
									val_count+=ret_val;									
							}
						}
					}
					else ret+=WORD_LEN;
				}//for					
			}

exit_level_1:
			val_count=0;
			bitData[val_dim].bitmaps[iter->val].pos = -1;			

		}//for
	
		/* Clear bitmaps */
		n_uple_val[child_dim].val = 0;
		n_uple_val[val_dim].val=0;		
		return;

	}//case 1

    /* More than one child */
	default:
	{
		int indice=0, y;	

		for(int i=0;iter!=bitData[val_dim].bitmap_pos.end(); iter++,i++)
		{
			//Controlla la soglia
			if(iter->count<minSup)
			{
			//	upper_bit[val_dim]->set_bit_to_0(i/WORD_LEN,i%WORD_LEN);
				goto exit_level_1b;
			}
			fprintf(fo,"%s%d ",str_v.c_str(),iter->val);

			print_t_upla(val_dim,iter->count);

			if(iter->count==1){

				for(y=1; y<=child->num_child(); y++)
					tmp_val.push_back(bitData[val_dim+y].bitmap_pos[bitData[val_dim].
						bitmaps[iter->val].mapDim[indice+y-1].get_last_bit()].val);

				sprintf(tmp,"%d ",iter->val);
				tmp_st=str_v+tmp;
				printf_other_t_uple_n(tmp_st,val_dim+1);
				tmp_val.clear();
			}
			else
			{
				n_uple_val[val_dim].val =  iter->val;
				n_uple_val[val_dim].cont_val = iter->count;
				compute_aggregates(child, data);
			}

		exit_level_1b:
			bitData[val_dim].bitmaps[iter->val].pos = -1;

		}
		n_uple_val[val_dim].val = 0;		
		return;

	}//default

	}//switch
	
}

/* Case 4. Level 2 - Generic Node */
void case_level_two(Node* child, int **data)
{		
	char tmp[MAX_STRING_LEN];
	string tmp_st;
	int val_dim = child->get_val_dim();	

	//Compute previous value
	string str_v = string_value(val_dim);
	int index, ret, ret_val, j, i,size_pos=bitData[val_dim].bitmap_pos.size();

	for(i=val_dim-1; i>=1; i--)
		if(n_uple_val[i].val!=0) { index=i; break; }	
		
	bool flag_sort=(val_dim-dim_local==2)?1:0;		

	int  val_count=0, val_tot=0, value;
	int  new_index=val_dim-index-1, val_index=n_uple_val[index].val;

	int init_bit=bitData[index].bitmaps[val_index].mapDim[new_index].
			get_current_bit();

	int last_bit=bitData[index].bitmaps[val_index].mapDim[new_index].
			get_last_bit();

	int first_word = init_bit/WORD_LEN;
	int last_word = last_bit/WORD_LEN;

	/*bitData[index].bitmaps[val_index].mapDim[new_index].
			make_and(upper_bit[val_dim]->ret_bit_dimAll(),
			first_word,last_word);*/

	for(i=first_word, ret=first_word*WORD_LEN; i<=last_word; i++)
	{
		if(bitData[index].bitmaps[val_index].mapDim[new_index].check_word(i))
		{
			for(j=0; j<WORD_LEN && ret<size_pos; j++, ret++)
			{
				if( bitData[index].bitmaps[val_index].mapDim[new_index].get_bit(i,j))
				{
							value=bitData[val_dim].bitmap_pos[ret].val;							
							if(child->num_child()==0)
							{
								if(flag_sort)
									ret_val=bitData[val_dim].bitmaps[value].
									map->make_and_two_without_mem_and_F1_sorted(bitData[index].bitmaps[val_index].map);
								else
									ret_val=bitData[val_dim].bitmaps[value].
									map->make_and_two_without_mem_and_F1(bitData[index].bitmaps[val_index].map);

								if(ret_val>=minSup)
									fprintf(fo,"%s%d ,%d\n",str_v.c_str(),value,ret_val);
								else bitData[index].bitmaps[val_index].mapDim[new_index].set_bit_to_0(i,j);

								val_count+=ret_val;
								if(val_count==n_uple_val[index].cont_val)
									goto exit_level_2;
							}
							//Il nodo ha figli
							else
							{							
								/* Fa il merge con le liste
								 * e memorizza l'informazione 
								*/
								if(flag_sort)
									n_uple_val[val_dim]
									.mapAND->make_and_two_with_mem_and_F1_sorted(bitData[index].bitmaps[val_index].map,
										bitData[val_dim].bitmaps[value].map,val_dim);
								else 
								n_uple_val[val_dim]
									.mapAND->make_and_two_with_mem_and_F1(bitData[index].bitmaps[val_index].map,
										bitData[val_dim].bitmaps[value].map,val_dim);
								
								ret_val=n_uple_val[val_dim].cont_val;
								val_count+=ret_val;
								n_uple_val[val_dim].val = value;
								
								if(ret_val>=minSup)
								{
									fprintf(fo,"%s%d ",str_v.c_str(),value);
									print_t_upla(val_dim, ret_val);
									
									if(ret_val==1)
									{
											if(child->num_child()==1)
											{
												fprintf(fo,"%s%d %d ,1\n",str_v.c_str(),value,
												data[val_dim+1][n_uple_val[val_dim].record+init_area]);
											}
											else
											{
												sprintf(tmp,"%d ",value);
												tmp_st=str_v+tmp;
												printf_other_t_uple_n_data(tmp_st,val_dim+1,child->num_child(),data);
											}
									}
									else																
										compute_aggregates(child, data);	

									if(val_count==n_uple_val[index].cont_val)
										goto exit_level_2;
								}//if
								else bitData[index].bitmaps[val_index].mapDim[new_index].set_bit_to_0(i,j);
					}//if
				}
			}
			}//if
			else ret+=WORD_LEN;
		}//for
		exit_level_2:
			n_uple_val[val_dim].val = 0;
}

/* Case 5. Level 3 */
void case_other_level(Node *child, int **data)
{	
	char tmp[MAX_STRING_LEN];
	string tmp_st;
	int val_dim = child->get_val_dim();

	int val_count = 0, ret_val = 0, val_tot = 0, ret, j;
	int value, i, y, size_pos=bitData[val_dim].bitmap_pos.size(), level=child->get_level();

	  vector<int> prec_val;
	for(i=val_dim-1, y=0; i>=1 && y<level-1; i--)
		if(n_uple_val[i].val!=0){	y++; prec_val.push_back(i);	}
	
	//bool flag_sort=(val_dim-dim_local==child->get_level())?1:0;		

	//Compute previous value
	int prec_val_dim = prec_val[0];
	bool flag=0;
	string str_v = string_value(val_dim);	
	int init,last;

	n_uple_val[val_dim].mapNodeDim->make_and_maps(0, prec_val, val_dim, &init, &last);	
	if(child->num_child()!=0) flag=1;	
	
	for(i=init, ret=init*WORD_LEN; i<=last; i++)
	{
		if(n_uple_val[val_dim].mapNodeDim->check_word(i))
		{
			for(j=0; j<WORD_LEN && ret<size_pos; j++, ret++)
				if(n_uple_val[val_dim].mapNodeDim->get_bit(i,j))
				{
						value=bitData[val_dim].bitmap_pos[ret].val;
						
						n_uple_val[val_dim].mapAND->make_and_two_with_mem_sorted2(flag,n_uple_val[prec_val_dim].mapAND,
								bitData[val_dim].bitmaps[value].map, prec_val_dim, val_dim);
																			
						ret_val=n_uple_val[val_dim].cont_val;						

						if(ret_val>=minSup){

							fprintf(fo,"%s%d ",str_v.c_str(),value);
							print_t_upla(val_dim,ret_val);
							val_tot+=ret_val;
							
							if(flag)
							{
								if(ret_val==1)
								{
									if(child->num_child()==1)
									{
										fprintf(fo,"%s%d %d ,1\n",str_v.c_str(),value,
										data[val_dim+1][n_uple_val[val_dim].record+init_area]);
									}
									else
									{
										sprintf(tmp,"%d ",value);
										tmp_st=str_v+tmp;
										printf_other_t_uple_n_data(tmp_st,val_dim+1,child->num_child(),data);
									}
								}
								else
								{
										n_uple_val[val_dim].val = value;																		
										compute_aggregates(child, data);
								}										
							}
							if(val_tot==n_uple_val[prec_val_dim].cont_val)
								goto exit_level_3;
					}
				}
		}//if
		else ret+=WORD_LEN;
	}//for

exit_level_3:
		n_uple_val[val_dim].val = 0;
		prec_val.clear();
}

/* Make aggregations */
void compute_aggregates(Node* RootTree, int** data)
{	
	for(int i=RootTree->num_child()-1; i>=0; i--)
	{	
		switch(RootTree->get_child_in_pos(i)->get_level()){

					case 1:	case_level_one(RootTree->get_child_in_pos(i),data);
							break;

					case 2: case_level_two(RootTree->get_child_in_pos(i),data);
							break;

					default: case_other_level(RootTree->get_child_in_pos(i),data);
							 break;
		}
	}
}


/*********************MAIN*********************/
int main(int argc, char **argv)
{
	if (argc > 4 ) {
		cout << " <program_name> <datafile> <threshold> [DSC|ASC]" << endl;
		exit(1);
	}
	clock_t time_end,  time_init=clock();

	int **data = NULL;
	//FULL CUBE
	//minSup=1;
	minSup=atoi(argv[2]);

	memset(mask2,(unsigned)0,sizeof(unsigned)*WORD_LEN);
	mask2[0]=mask2[0]^mask[0];

	/* Compute mask */
	for(int i=1; i<WORD_LEN; i++){
		mask[i]=(unsigned)2*mask[i-1];
		mask2[i]=mask2[i]^mask[i];
	}
			
	/* Read file */
	data = read_datafile(data,argv[1]);

	clock_t time_end1 = clock();

	/* Start Computation */
	if(argc == 3 || (argc == 4 && !strcmp(argv[3],"DSC")))
	{
		cout << endl << "Method: bitCubeD " ;
		printf("\nTime of Read Data Time: %.2f seconds",
	   (double)(time_end1-time_init)/(double)CLOCKS_PER_SEC);

		bucBitmapDSC(data, 0, n_tuples);
	}
	else
	{
		cout << " <program_name> <datafile> <threshold> [DSC|ASC]" << endl;
		exit(1);
	}

	fclose(fo);

	/* Get Total Time */
	time_end=clock();
	printf("\nTotal Time: %.2f seconds\n",
	   (float)(time_end-time_init)/CLOCKS_PER_SEC);

	/* Clean up */
	pos.clear();
	card.clear();
	n_uple_val.clear();

	return 0;
}
