/*
  GraphBlast Algorithm
  tools.cpp
*/

#include "common.h"
#include <map>
using std::map;

clockmap v_clock_old;
clockmap v_clock_sum;

// clocks functions for computing different processing time

void printtime(char* name,char* name1,char* name2){
	typedef map<char*,double> clockmap;
	v_clock_sum[name]=(double)v_clock_sum[name1]- (double)v_clock_sum[name2];
	cout<< name << ": "<<(double)v_clock_sum[name]/((double)CLOCKS_PER_SEC)<<"\n";
}

void printtime(char* name){
	cout<< name << ": "<<(double)v_clock_sum[name]/((double)CLOCKS_PER_SEC)<<"\n";
}

void setclock(char* name,int end_flag=0){
	clockmap::iterator it=v_clock_sum.find(name);

	if(it==v_clock_sum.end()){	//start from beginning
		v_clock_old[name]=(double)clock();
		v_clock_sum[name]=0;
	}else{	//already started
		if(end_flag==1){
			double now=(double)clock();
			v_clock_sum[name] +=now-v_clock_old[name];		
			v_clock_old[name]=now;
		}else{
			v_clock_old[name]=(double)clock();
		}
		
	}
}

const string delims(" \t\x0D");

// separate words from a constant string str
vector<string> sep_words(const string& str){
	vector<string> tmp_words;
	tmp_words.reserve(8);

	string::size_type begIdx,endIdx;

	begIdx= str.find_first_not_of(delims);
	while(begIdx!=string::npos){
		endIdx=str.find_first_of(delims,begIdx);
		if(endIdx==string::npos)
			endIdx=str.length();

		tmp_words.push_back(str.substr(begIdx,endIdx-begIdx));
		begIdx=str.find_first_not_of(delims,endIdx);
	}
	return vector<string>(tmp_words);
}
