
import java.io.*;
import java.awt.*;
import java.util.*;
import simpleGamePlatform.*;

public class sumGame extends GamePlatform
{
   int[] notes = {0, 2, 4, 5, 7, 9, 11, 12};
   int N = 8;
   MusicKeyboard keyboard = new MusicKeyboard(notes);
   Score score = new Score();
   Random R = new Random(0);
   Font bigFont = new Font("Helvetica", Font.BOLD, 23);
   Font smallFont = new Font("Helvetica", Font.BOLD, 20);
   Color color[] = {Color.red,new Color(255,128,0),Color.yellow,Color.green,
                    Color.cyan,new Color(140,140,255),Color.magenta,Color.red};

   public void setup() {
      int w = getWidth(), h = getHeight();

      setProjectName("games-class");

      // CREATE A SET OF MUSICAL KEYS

      int x = 0;
      for (int n = 0 ; n < N ; n++) {
         int b = 10 + 5 * (N - n);
         RectPiece t = new RectPiece();
         t.setBounds(x += 2 * b, h / 2 - b / 2, b, b);
         addPiece(t);
         t.setColor(color[n]);
         t.setLabel("" + n);
	 track(t, "THING_" + n, "x y");
      }

      // CREATE A MALLET

      addPiece((new DiskPiece()).setBounds(w/2 - 20, h/4 - 20, 40, 40));
      piece(N).setColor(new Color(180, 180, 180));

      setCollisionTracked(piece(N));

      track(score, "SCORE");
   }

   public void startCollision(Piece one, Piece two) {
      two.setColor(Color.black);
      keyboard.addNote(two.getId());
      score.sum += two.getId();
      if (score.sum == score.targetSum)
         score.score++;
      if (score.sum >= score.targetSum) {
         score.round++;
         score.sum = 0;
	 score.targetSum = Math.abs(R.nextInt()) % 20;
      }
   }

   public void endCollision(Piece one, Piece two) {
      two.setColor(color[two.getId()]);
   }

   public void update() {
      keyboard.playNotes();
   }

   public void overlay(Graphics g) {
      Font font = g.getFont();
      g.setFont(bigFont);
      g.setColor(Color.black);
      g.drawString("target: " + score.targetSum, 20, 40);
      g.drawString("your sum: " + score.sum, 20, 80);
      g.setColor(Color.red);
      g.drawString("score: " + score.score, getWidth() / 2 - 50, 40);
      g.setColor(Color.blue);
      g.drawString("Drag the ball over the squares.",
                   20, getHeight() - 110);
      g.drawString("You score when your sum matches the target.",
                   20, getHeight() - 70);
      g.drawString("It's more fun if you also make nice melodies.",
                   20, getHeight() - 30);
      g.setFont(smallFont);
   }

   // SUPPORT FOR MIDI IN GAME

   public void stop() {
      super.stop();
      keyboard.stop();
   }
}

