% RNDINF  generates sdp problems with strictly feasible primal and
%         dual points but sets the starting point (X,y,Z) = (I,0,I),
%         which is (most likely) infeasible
% The following variables must be available in the Matlab workspace:
%    - blk      block structure vector
%    - m        number of constraints
%

% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97
%
 nblk = length(blk);
 n = sum(blk);
 n2 = (sum(blk .* (blk+1)))/2;
 if m > n2,
    fprintf('rndinf: This block structure allows a maximum of %d constraints.\n', n2);
    fprintf('rndinf: Constraints will be consistent, but redundant.\n');
 end;

 A = zeros(m,n2);
%
 for i = 1:m,
    A(i,:) = svec(brandsym(blk),blk)';  % a full vector
 end;
%
 Ztemp = brandpos(blk);  % a sparse matrix if nblk > 1
 ytemp = rand(m,1);
 C = smat(A'*ytemp,blk) + Ztemp;  % constructed so a dual feasible point exists
 Xtemp = brandpos(blk);  % a sparse matrix if nblk > 1
 b = A*svec(Xtemp,blk);  % constructed so a primal feasible point exists
%
 clear Xtemp ytemp Ztemp  % discard these
