#pragma once

#include <stdint.h>

typedef struct {
	char *infile;
	void *image;	// pointer to memory-mapped, private copy of infile
	int size;
	Elf32_Ehdr *ehdr;
	uint8_t saved_mov_instruction[5];
} Rewriter;

uint32_t symbol_lookup(char *filename, char *symbolname);
void rewriter_open(Rewriter *rw, char *infile);
void *rewriter_virtual_to_mapped(Rewriter *rw, uint32_t vaddr);
uint32_t rewriter_scan_write(Rewriter *rw, void *write_func);
void rewriter_patch_write(Rewriter *rw, uint32_t write_vaddr, uint32_t empty_space_vaddr);
void rewriter_create_trampoline(Rewriter *rw, uint32_t empty_space_vaddr, uint32_t target_vaddr);
void rewriter_edit(Rewriter *rw);
void rewriter_emit(Rewriter *rw, char *outfile);
int main(int argc, char **argv);

