function result = elementwisefunction(f,varargin)
%Converts a function into one that can take multidimensional input
d = length(varargin);
result = zeros(size(varargin{1}));
vLim = size(varargin{1});
v     = ones(1,length(vLim));
ready = false;
while ~ready
    Index = arrayindexing.sub2indV(vLim, v);
    Input = cell(1,d);
    for i = 1:d
        vari = varargin{i};
        Input{i} = vari(Index);
    end
    result(Index) = f(Input{:});
    
    % Update the index vector:
    [v,ready] = arrayindexing.updateindexvec(v,vLim);
end



% %Alternative version:
% n = numel(varargin{1});
% d = nargin(f);
% for i = n:-1:1
%     Input = cell(1,d);
%     for j = 1:d
%         vari = varargin{j};
%         Input{j} = vari(Index);
%     end
%     result(i) = f(Input{:});
% end
% result = reshape(result,size(varargin{1}));
% end