function [fig,ax] = createfigure(boxdimensions,sizex,position)
    %boxdimensions can be a "box", "interval vector" or a 3*2 matrix
    %size 
    %position is a value between 0 and 1 and determines how far to the right the figure is plotted
    if isa(boxdimensions,"box")
        boxdimensions = boxdimensions.boxdimensions;
    elseif isa(boxdimensions,"interval")
        [b1,b2,b3] = boxdimensions.bounds;
        boxdimensions = [b1;b2;b3];
    end
    fig = figure;
    r = groot;
    Monitors = r.MonitorPositions;
    [~,M] = max(Monitors(:,3));
    pause(0.01);
%     set(fig, 'units', 'pixels', 'position', Monitors(M,:));
    boundingboxdiff = boxdimensions(:,2)-boxdimensions(:,1);
    ratio = 1;
    if nargin == 1
        sizex = 800;
    end
    if nargin > 2
        xtranslation = position*(Monitors(M,3)-sizex);
    else
        xtranslation = 0;
    end
    set(fig, 'units', 'pixels', 'position', [xtranslation,50,sizex,sizex*ratio]);
    ax = axes(fig);
    %axis(axVD,reshape(range(1:2,1:2)',1,4))
    setAxes3DPanAndZoomStyle(zoom(ax),ax,'camera');
    ax.XAxis.Color = 'b';
    ax.YAxis.Color = 'r';
    ax.ZAxis.Color = 'g';
    xlabel('x');
    ylabel('y');
    zlabel('z');
    length0 = abs(boxdimensions(:,2)-boxdimensions(:,1))<5*eps;
    plotinterval = boxdimensions;
    plotinterval(length0,:) = boxdimensions(length0,:)+0.5*[-ones(sum(length0),1),ones(sum(length0),1)];
    plotinterval = plotinterval';
    plotinterval = reshape(plotinterval(:),1,[]);
    axis(ax,plotinterval);
%                 r1 = boundingbox(1,2)-boundingbox(1,1);
%                 r2 = boundingbox(2,2)-boundingbox(2,1);
%                 pbaspect([r1, r2, max(r1,r2)])
    daspect(ax,[1 1 1]);
    hold(ax,"on");
    axis(ax,"on");
    if length(plotinterval) == 6
        view(25,25);
    end
end