class Fibonacci {
	function fib(n: nat) : nat 
	{
		if (n < 2) then n else fib(n-2) + fib(n-1)
	}

	method computeFib(n: nat) returns (m: nat) 
		ensures m == fib(n);
	{
		var i := 0;
		var k := 1;
			m := 0;
		while (i < n)
			invariant 0 <= i <= n;
			invariant m == fib(i) && k == fib(i+1); 
		{
			i := i + 1;
			m, k := k, k + m;
		}
	}
}