class BinarySearch {
	predicate sorted(a: array<int>)
		requires a != null;
		reads a;
	{
		forall j, k :: 0 <= j < k < a.Length ==> a[j] <= a[k]
	}

	method BinarySearch(a: array<int>, key: int) returns (index: int)
		requires a != null && sorted(a);
		ensures index == -1 ==> (forall i :: 0 <= i < a.Length ==> a[i] != key);
		ensures index != -1 ==> 0 <= index < a.Length && a[index] == key;
	{   
		var low, high := 0, a.Length;
		while (low < high) 
			invariant 0 <= low <= high <= a.Length;
			invariant (forall i :: 0 <= i < low || high <= i < a.Length ==> a[i] != key);
		{
			var mid := low + (high - low) / 2;
			if (a[mid] < key) {
				low := mid + 1;
			} else if (a[mid] > key) {
				high := mid;
			} else {
				return mid;
			}
		}
		return -1;
    }
}