// Derived from an example in the Boogie distribution

class ArraySet<T(==)> {
    var values : array<T>;
    var size : int;
    ghost var content : set<T>;

    predicate sameElems(C:set<T>, a:array<T>, n:int)
        requires a != null;
        requires 0 <= n && n <= a.Length;
        reads a;
    {
        forall x :: x in C <==> (exists j :: 0 <= j && j < n && a[j] == x)
    }

    predicate Valid()
        reads this, this.values;
    {
        values != null
        && 0 <= size <= values.Length
        && sameElems(content, values, size)
    }

    method Init(N:int)
        requires 0 <= N;
        ensures Valid();
        ensures content == {};
        modifies this;
    {
        var t := new T[N];
        values := t;
        size := 0;
        content := {};
    }

    method add(x:T)
        requires Valid();
        ensures Valid();
        ensures content == old(content) + {x};
        modifies this.values, this;
    {
        var n := 0;
        while (n < size)
            invariant Valid();
        {
            if (values[n] == x) {
                return;
            }
            n := n + 1;
        }
        if (size == values.Length) {
			var values1 := new T[2*size+1];
			parallel (i | 0 <= i < values.Length) {
				values1[i] := values[i];
			}
			values := values1;
		}
        values[size] := x;
        size := size + 1;
        content := content + {x};
    }

}
