public class LockTest {
  volatile static int counter;
  static Lock mutex;
  
  public static class Counter implements Runnable {
    private int id;
    Counter(int id) {
      this.id = id;
    }
    
    public void run() {
      while (true) {
        try {
          mutex.lock(id);
          if (counter >= 1000000) break;
          counter++;
        } finally { mutex.unlock(id); }
      }
      //System.out.println("Thread " + id + " is done.");
      System.out.flush();
    }
  }

  public static void usage() {
    System.out.println("Usage: java LockTest <number of threads>");
  }

  public static void main(String[] args) throws InterruptedException {
    if (args.length == 0) {
      usage();
      return;
    }

    int n;
    try {
      n = Integer.parseInt(args[0]);
    } catch (NumberFormatException e) {
      usage();
      return;
    }

    mutex = new TASLock();
    Thread[] thread = new Thread[n];

    for (int i = 0; i < n; i++) {
      thread[i] = new Thread(new Counter(i));
    }

    counter = 0;
    for (Thread t : thread) { t.start(); }
    
    for (Thread t : thread) { t.join(); }
    
    System.out.println("The final value of 'counter' is: " + counter);
  }
  

}