public class SimpleReadWriteLock implements ReadWriteLock {
  volatile int readers;
  volatile boolean writer;
  Lock readLock, writeLock;

  public SimpleReadWriteLock() {
    writer = false;
    readers = 0;
    readLock = new ReadLock();
    writeLock = new WriteLock();
  }

  public Lock readLock() {
    return readLock;
  }

  public Lock writeLock() {
    return writeLock;
  }
  
  class ReadLock implements Lock {
    public void lock() throws InterruptedException {
      synchronized(SimpleReadWriteLock.this) {
        while (writer) {
          wait();
        }
        readers++;
      }
    }

    public void unlock() {
      synchronized(SimpleReadWriteLock.this) {
        readers--;
        if (readers == 0) {
          notifyAll();
        }
      }
    }
  }

  class WriteLock implements Lock {
    public void lock() throws InterruptedException {
      synchronized(SimpleReadWriteLock.this) {
        while (readers > 0 || writer) {
          SimpleReadWriteLock.wait();
        }
        writer = true;
      }
    }

    public void unlock() {
      synchronized(SimpleReadWriteLock.this) {
        writer = false;
        SimpleReadWriteLock.notifyAll();
      }
    }
  }
}
