import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class Account {
  volatile int balance;
  volatile int preferedCount;
  Lock lock;
  Condition ordinary;
  Condition prefered;
  
  public Account() {
    balance = 0;
    preferedCount = 0;
    lock = new ReentrantLock();
    ordinary = lock.newCondition();
    prefered = lock.newCondition();
  }

  public void deposit(int k) {
    if (k < 0) {
      throw new IllegalArgumentException("tried to deposit negative amount");
    }
    lock.lock();
    try {
      balance += k;
      if (preferedCount > 0) {
        prefered.signalAll();
      } else {
        ordinary.signalAll();
      }
    } finally { 
      lock.unlock(); 
    }
  }

  public void withdraw(int k) throws InterruptedException {
    if (k < 0) {
      throw new IllegalArgumentException("tried to withdraw negative amount");
    }
    lock.lock();
    try {
      while (preferedCount > 0 || balance < k) {
        ordinary.await();
      }
      System.out.println("Withdrawing " + k);
      balance -= k;
    } finally {
      lock.unlock();
    }
  }

  public void withdrawPrefered(int k) throws InterruptedException {
    lock.lock();
    try {
      preferedCount++;
      while (balance < k) {
        prefered.await();
      }
      balance -= k;
      preferedCount--;
      if (preferedCount == 0 && balance > 0) {
        ordinary.signalAll();
      }
    } finally {
      lock.unlock();
    }
  }
}