package mergesort

import akka.actor.Actor
import akka.event.LoggingReceive
import akka.actor.Props
import akka.actor.ActorSystem
import scala.concurrent._
import scala.concurrent.duration.Duration
import ExecutionContext.Implicits.global

class MergeSort(l: List[Int], p: Promise[List[Int]]) extends Actor {
  val root = context.actorOf(Props(new Sorter))

  l.foreach { root ! Some(_) }
  root ! None

  def collectResult(result: List[Int]): Receive = LoggingReceive {
    case Some(x:Int) => 
      context.become(collectResult(x +: result))
    case None => 
      p.success(result.reverse)
  }

  def receive = collectResult(Nil)
}

object main extends App {
  val input = List(1, 5, 3, 2)
  println(s"Input: $input")

  val system = ActorSystem("MergeSort")
  val p = Promise[List[Int]]
  val m = system.actorOf(Props(new MergeSort(input, p)))

  val output = Await.result(p.future, Duration.Inf)

  p.future onSuccess { 
    case output => 
      system.shutdown
      println(s"Output: $output") 
  }
  // Alternatively: val output = Await(p.future, Duration.Inf)
  // Though be careful as this alternative lets the thread block 
  // until the future is completed.
}
