#include <vector>
#include <algorithm>
#include <iostream>

using namespace std;

// Print Iterator CATegory.

void picat(std::input_iterator_tag t) {
  std::cout << "input iterator" << std::endl;
}

void picat(std::output_iterator_tag t) {
  std::cout << "output iterator" << std::endl;
}

void picat(std::forward_iterator_tag t) {
  std::cout << "forward iterator" << std::endl;
}

void picat(std::bidirectional_iterator_tag t) {
  std::cout << "bidirectional iterator" << std::endl;
}

void picat(std::random_access_iterator_tag t) {
  std::cout << "random access iterator" << std::endl;
}

bool greater_than_9(int v) {
  return v > 9;
}

struct Sum {
  int res;
  Sum(int i = 0) : res(i) {}
  void operator() (int i) { res += i; }
  int result() { return res; }
};

int main() {
  vector<int> iv(10);

  picat(vector<int>::iterator::iterator_category());

  for (int i = 0; i < 10; i++) {
    iv[i] = i * i;
  }

  for (vector<int>::iterator iter = iv.begin();
       iter != iv.end(); 
       ++iter) {
    cout << *iter << " ";
  }
  cout << endl;

  Sum sum;

  sum = for_each(iv.begin(), iv.end(), sum);

  cout << "Summation is " << sum.result() << endl;
}
