/*
 * Object-Oriented Programming
 * Copyright (C) 2012 Robert Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
 * USA.
 */

#include <iostream>

#include "java_lang.h"

using namespace java::lang;

int main(void) {
  // Let's get started.
  std::cout << "--------------------------------------------------------------"
            << "----------------"
            << std::endl;

  // int[] a = new int[5];
  ArrayOfInt a = new __ArrayOfInt(5);

  // Class aClass = a.getClass();
  Class aClass = a->__vptr->getClass(a);

  // aClass.getName()
  std::cout << "a.getClass.getName()  : "
            << aClass->__vptr->getName(aClass)->data << std::endl;

  // a[2]
  __rt::checkIndex(a->length, 2);
  std::cout << "a[2]  : " << a->__data[2] << std::endl;

  // a[10]
  __rt::checkIndex(a->length, 10);
  std::cout << "a[10] : " << a->__data[10] << std::endl;

  // Done.
  std::cout << "--------------------------------------------------------------"
            << "----------------"
            << std::endl;
  return 0;
}
