function [A,b,C,blk] = import(fname)
% IMPORT  imports SDP data stored in a variant of Nemirovskii's
%         compact form into matlab; see export.m for details about
%         the storage scheme.
%
% [A,b,C,blk] = import(fname)
%
% input variables:
%     - fname     the name of the output file
%
% output variables:
%     - A         matrix of primal constraints
%     - b         rhs of primal constraints
%     - C         cost matrix
%     - blk       block structure vector

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified: 6/18/97
%
 eval(['load ',fname]);
% strip path specification and extension if any
 [s,r]= strtok(fname,'/'); % strip all the /
 while any(r)
    [s,r]= strtok(r,'/');
 end
 if computer == 'PCWIN'    % if running on PC strip all \
    [s,r]= strtok(s,'\');
    while any(r)
       [s,r]= strtok(r,'\');
    end
 end
 [s,r]= strtok(s,'.');     % strip all extensions
%
 idx = 1;
 eval(['m = ',s,'(idx);']);             % m = # constraints
 idx = idx + 1;
%
% get b
%
 b = zeros(m,1);
 for i = 1:m
    eval(['b(i) = ',s,'(idx);']);
    idx = idx + 1;
 end
 eval(['nblk.s = ',s,'(idx);']);          % nblk = # blocks
 idx = idx + 1;
 if nblk.s > 0
    blk.s = zeros(nblk.s,1);
    for i = 1:nblk.s                 % read in block sizes
       eval(['blk.s(i) = ',s,'(idx);']);
       idx = idx + 1;
    end
    n = sum(blk.s);
%
% make lookup table of starting points of SD blocks
%
    start(1) = 0;
    for k = 2:nblk.s
       start(k) = start(k-1) + blk.s(k-1);
    end
%
% get the matrix C.s
%
    eval(['sparseblocks = ',s,'(idx);']);  % are blocks sparse?
    if nblk.s > 1 | sparseblocks == 1
       C.s = sparse(n,n);
    else
       C.s = zeros(n,n);
    end
    for blkidx = 1:nblk.s
       bsize = blk.s(blkidx);
       ulc = start(blkidx);
       lrc = ulc + bsize;
       ulc = ulc+1;
       eval(['spblk = ',s,'(idx);']);  % check for consistency
       idx = idx + 1;
       if spblk ~= sparseblocks
          error('Mixing sparse and dense blocks in C.s is not allowed');
       end
       if sparseblocks == 1    % data is in sparse format
          tmpmat = sparse(bsize,bsize);
          eval(['nz = ',s,'(idx);']);  % # nonzeros entries in block blkidx
          idx = idx + 1;
          for k = 1:nz
             eval(['rowidx = ',s,'(idx);']);  % row index
             idx = idx + 1;
             eval(['colidx = ',s,'(idx);']);  % column index
             idx = idx + 1;
             eval(['tmpmat(rowidx,colidx) = ',s,'(idx);']);
             idx = idx + 1;
          end    % k loop
       else   % matrix is full
          tmpmat = zeros(bsize,bsize);
          for i = 1:bsize
             eval(['tmpmat(i:bsize,i) = ',s,'(idx:idx+bsize-i);']);
             idx = idx + bsize - i + 1;
          end
       end   % if sparseblocks
       C.s(ulc:lrc,ulc:lrc) = tmpmat;  % assign the block to C.s
    end    % blkidx loop
%
% now symmetrize C.s: note that C.s is currently a lower triangular matrix
%
    d = diag(C.s);
    C.s = C.s - diag(d);
    C.s = C.s + C.s';
    C.s = C.s + diag(d);
%
% get the matrices A1,...,Am
%
    n2 = (sum(blk.s .* (blk.s+1)))/2;
    eval(['sparseblocks = ',s,'(idx);']); % are blocks sparse?
    if sparseblocks
       A.s = sparse(m,n2);
    else
       A.s = zeros(m,n2);
    end
    for cstridx = 1:m
       if nblk.s > 1 | sparseblocks == 1  % data is in sparse format
          Ak = sparse(n,n);               % Ak gets initialized to 0
       else
          Ak = zeros(n,n);
       end
       for blkidx = 1:nblk.s
          eval(['spblk = ',s,'(idx);']);  % is block sparse?
          idx = idx + 1;
          if sparseblocks ~= spblk
             error('Mixing sparse and dense blocks in A.s is not allowed');
          end
          bsize = blk.s(blkidx);
          ulc = start(blkidx);
          lrc = ulc + bsize;
          ulc = ulc+1;
          if sparseblocks == 1          % data is in sparse format
             tmpmat = sparse(bsize,bsize);
             eval(['nz = ',s,'(idx);']);
             idx = idx + 1;
             for k = 1:nz
                eval(['rowidx = ',s,'(idx);']);
                idx = idx + 1;
                eval(['colidx = ',s,'(idx);']);
                idx = idx + 1;
                if rowidx < colidx     % swap indices to get lower triangle
                   tmpidx = colidx;
                   colidx = rowidx;
                   rowidx = tmpidx;
                end
                eval(['tmpmat(rowidx,colidx) = ',s,'(idx);']);
                idx = idx + 1;
             end    % k loop
          else    % matrix is full
             tmpmat = zeros(bsize,bsize);
             for i = 1:bsize
                eval(['tmpmat(i:bsize,i) = ',s,'(idx:idx+bsize-i);']);
                idx = idx + bsize - i + 1;
             end
          end   % if sparseblocks
          Ak(ulc:lrc,ulc:lrc) = tmpmat;
       end    % blkidx loop
%
% Note that the matrix Ak currently is a lower triangular matrix.
% There is no need to symmetrize Ak since it will only be fed to svec
% and svec only uses the lower triangular part of its matrix argument.
% Now store Ak in appropriate row of A.s
%
       A.s(cstridx,:) = (svec(Ak,blk.s,spblk))';
    end    %  cstridx loop
 end    % if nblk.s
%
% Now, read in the QC part
%
 eval(['nblk.q = ',s,'(idx);']);          % nblk = # blocks
 idx = idx + 1;
 if nblk.q > 0
    blk.q = zeros(nblk.q,1);
    for i = 1:nblk.q                 % read in block sizes
       eval(['blk.q(i) = ',s,'(idx);']);
       idx = idx + 1;
    end
    n = sum(blk.q);
% read in the cost vector from the QC part
    eval(['C.q = ',s,'(idx:idx+n-1);']);
    idx = idx + n;
    eval(['spblk = ',s,'(idx);']);
    idx = idx + 1;
    if spblk == 1
       A.q = sparse(m,n);
       eval(['nz = ',s,'(idx);']);
       idx = idx + 1;
       for i=1:nz
          eval(['rowidx = ',s,'(idx);']);
          idx = idx + 1;
          eval(['colidx = ',s,'(idx);']);
          idx = idx + 1;
          eval(['A.q(rowidx,colidx) = ',s,'(idx);']);
          idx = idx + 1;
       end   % i loop
    else
       eval(['dummy = ',s,'(idx:idx+(m*n)-1);']);
       A.q = reshape(dummy,m,n);
       idx = idx + m*n;
    end    % if spblk
 end    % if nblk.q
%
% Now, the LP part
%
 eval(['nl = ',s,'(idx);']);
 idx = idx + 1;
 if nl > 0
    blk.l = nl;
    eval(['C.l = ',s,'(idx:idx+blk.l-1);']);
    idx = idx + nl;
    eval(['spblk = ',s,'(idx);']);
    idx = idx + 1;
    if spblk == 1
       A.l = sparse(m,blk.l);
       eval(['nz = ',s,'(idx);']);
       idx = idx + 1;
       for i=1:nz
          eval(['rowidx = ',s,'(idx);']);
          idx = idx + 1;
          eval(['colidx = ',s,'(idx);']);
          idx = idx + 1;
          eval(['A.l(rowidx,colidx) = ',s,'(idx);']);
          idx = idx + 1;
       end   % i loop
    else
       eval(['dummy = ',s,'(idx:idx+(m*blk.l)-1);']);
       A.l = reshape(dummy,m,blk.l);
    end    % if spblk
 end    % if blk.l
%
% END function
