function A = brandsym(blk)
% BRANDSYM  builds a block diagonal random symmetric matrix
%           with block structure given by the vector blk
%
% A = brandsym(blk)
%
% input variables:
%  - blk          block structure vector
%
% output variables:
%  - A            a symmetric block diagonal matrix

% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97
%
 nblk = length(blk);
 n = sum(blk);
 if nblk > 1,
    A = sparse(n,n);
 else,
    A = zeros(n,n);
 end;
 start = 1; fin = 0;
 for i = 1:nblk,
    bsize = blk(i);
    fin = fin + bsize;
    A(start:fin,start:fin) = randsym(bsize);
    start = start + bsize;
 end;
%
% END function
