function [dX,dy,dZ] = dsdpsol(X,Zinv,Rd,rp,Rc,Cholfac)
% DSDPSOL   computes solution of 3x3 linear system for SDP
%           (diagonal constraints case); to be used with dsdp.m
%
% [dX,dy,dZ] = dsdpsol(X,Zinv,Rd,rp,Rc,Cholfac)
%
% input variables:
%     - X         the primal variable
%     - Zinv      the inverse of the dual slack
%     - Rd        the dual residual: C - A'*y - Z
%     - rp        the primal residual: b -A*svec(X)
%     - Rc        the centrality residual
%     - Cholfac   the Choleski factor of the Schur complement
%
% output variables:
%     - dX        the primal variable step
%     - dy        the dual variable step
%     - dZ        the dual slack step

% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97
%
 tmp1 = (X*Rd - Rc)*Zinv;
 yrhs = rp + diag(tmp1);
 dy = Cholfac\(Cholfac'\yrhs);
 m =length(dy);
 Dy = spdiags(dy,0,m,m);
 dZ = Rd - Dy;
 dX = -tmp1 + X*Dy*Zinv;
%
% END function
