function A = brandpos(blk)
% BRANDPOS  builds a block diagonal random positive definite symmetric
%           matrix with block structure given by the vector blk
%
% A = brandpos(blk)
%
% input variables:
%  - blk          block structure vector
%
% output variables:
%  - A            a block diagonal positive definite symmetric matrix

% SDPPACK Version 0.8 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton
% Last modified: 3/24/97
%
 nblk = length(blk);
 n = sum(blk);
 if nblk > 1,
    A = sparse(n,n);
 else,
    A = zeros(n,n);
 end;
 start = 1; fin = 0;
 for i = 1:nblk,
    bsize = blk(i);
    fin = fin + bsize;
    A(start:fin,start:fin) = randpos(bsize);
    start = start + bsize;
 end;   % i-loop
%
% END function
