function eigtool_sparse_driver(epsln, mod, prtlevel)
% n is set in the demo files
% mod = 0 for abscissa, 1 for radius
if nargin < 2
    mod = 0;
end
if nargin < 3
    prtlevel = 0;
end
[eigstr, nactual, spar, f, imagangle, iters, maxinnersteps, cpuratio] = psapsr_eigtool_sparse_examples(epsln, mod, prtlevel);
epslnstr = dotToUnderscore(sprintf('%g', epsln));
if ~mod
    fid = fopen(sprintf('sparse-abs-%s.tex', epslnstr),'w');
    greek = '\alpha';
    greekeps = '\alpha_\eps';
    imagorangle = 'imag(z)';
else
    fid = fopen(sprintf('sparse-rad-%s.tex', epslnstr),'w');
    greek = '\rho';
    greekeps = '\rho_\eps';
    imagorangle = 'arg(z)';
end
fprintf(fid, '\\begin{table}\n');
fprintf(fid, '\\begin{tabular}{|l|c|c|c|c|c|}\n');
fprintf(fid, '\\hline \n');
% nb is max number of bisections
fprintf(fid, ' call & $n$ & $%s$ & $%s$ & iters & nb\\\\ \n', ...
    greek, greekeps);
fprintf(fid, '\\hline \n');
for k = 1:length(eigstr)
    % don't print imagangle(k): too much clutter, but it is close to 0 in about half the cases
    % don't print cpuratio as the ratios are not very convincing: not sure why
    if ~isnan(f(k))
        fprintf(fid, '\\verb@%s@ & %d & $%g$ & $%g$ & %d & %d \\\\ \n', ...
           eigstr{k}, nactual(k), spar(k), f(k), iters(k), maxinnersteps(k)); 
    else
        fprintf(fid, '\\verb@%s@ & %d & %g & %g & %d & %d \\\\ \n', ... % no math mode for nan's, so not in italics
        eigstr{k}, nactual(k), spar(k), f(k), iters(k), maxinnersteps(k));
    end
end
fprintf(fid, '\\hline \n');
fprintf(fid, '\\end{tabular}\n');
%%%%%% fprintf(fid, '\\end{table}\n');
fclose(fid);



