function eigtool_dense_driver(n, epsln, mod)
% mod = 0 for abscissa, 1 for radius
if nargin < 3
    mod = 0;
end
% dense
[eigstr, nactual, spar, f, imagangle, fcc, iters, maxinnersteps, r] = ...
    psapsr_eigtool_dense_examples(n, epsln, mod, 0);
epslnstr = dotToUnderscore(sprintf('%g', epsln));
if ~mod
    fid = fopen(sprintf('dense-abs-%d-%s.tex', n, epslnstr),'w');
    greek = '\alpha';
    greekeps = '\alpha_\eps';
    imagorangle = 'imag(z)';
else
    fid = fopen(sprintf('dense-rad-%d-%s.tex', n, epslnstr),'w');
    greek = '\rho';
    greekeps = '\rho_\eps';
    imagorangle = 'arg(z)';
end
fprintf(fid, '\\begin{table}\n');
fprintf(fid, '\\begin{tabular}{|l|c|c|c|c|c|c|c|}\n');
fprintf(fid, '\\hline \n');
% nb is max number of bisections
fprintf(fid, ' call & $n$ & $%s$ & $%s$ & error & iters & nb & $r$ \\\\ \n', ...
    greek, greekeps);
fprintf(fid, '\\hline \n');
for k = 1:length(eigstr)
    error(k) = abs(f(k)-fcc(k));
    % don't print imagangle(k): too much clutter, but it is close to 0 in about half the cases
    fprintf(fid, '\\verb@%s@ & %d & $%g$  & $%g$ & $%7.1e$ & %d & %d & $%7.1e$ \\\\ \n', ...
        eigstr{k}, nactual(k), spar(k), f(k), error(k), iters(k), maxinnersteps(k), r(k));
end
fprintf(fid, '\\hline \n');
fprintf(fid, '\\end{tabular}\n');
%%%%%% fprintf(fid, '\\end{table}\n');
fclose(fid);