function [eigstr, n, spar, f, imagangle, iters, maxlineschsteps, cpuratio] = psapsr_eigtool_sparse_examples(epsln, mod, prtlevel)
% note that the sizes are set in eigtool_example_names
% run through the sparse eigtool examples
% set mod=0 for abscissa, mod=1 for radius
if nargin < 2
    mod = 0;
end
if nargin < 3
    prtlevel = 2;
end
fprintf('eigtool sparse examples, epsln=%g, mod=%d\n', epsln, mod)
[junk, sparsenames, sparseNvals] = eigtool_example_names;
for k=1: length(sparsenames)
    name = (sparsenames{k})
    eigstr{k} = sprintf('%s(%d)', name, sparseNvals{k});
    A = feval(strcat(name, '_demo'), sparseNvals{k});
    n(k) = length(A); % actual dimension
    options.maxit = 1000; % no point cutting it off at 100, sometimes needs more, but rarely
    options.prtlevel = prtlevel;
    try
        [f(k), x, y, z, info, xrec, yrec, zrec, trec, cpurec] = psapsr(A, epsln, mod, options);
        if ~mod
            imagangle(k) = imag(z); % imaginary part of optimal z
            spar(k) = real(zrec(1)); % spectral abscissa
        else
            imagangle(k) = angle(z); % complex argument of optimal z
            spar(k) = abs(zrec(1)); % spectral radius
        end
        iters(k) = length(zrec)-1; % not counting the initial iterate
        maxlineschsteps(k) = log2(1/min(trec(2:end)));
        cpuratio(k) = sum(cpurec)/cpurec(1);
    catch me
        me
        fprintf('*** an error occurred, probably because eigenvalues did not converge.  Setting result to NaN and continuing to next problem\n')
        f(k) = nan;
        spar(k) = nan;
        imagangle(k) = nan;
        iters(k) = nan;
        maxlineschsteps(k) = nan;
        cpuratio(k) = nan;
    end
    if prtlevel > 2
        fprintf('press any key to continue\n')
        pause
    end
end