function psapsr_demo(mod)

% PSAPSR_DEMO
% demo the psapsr code
% set mod=0 for spectral abscissa, mod=1 for spectral radius
% demonstrate use of psapsr
if nargin < 1
    mod = 0;
end
format long e
options.prtlevel = 2; % verbose output
% first the original version
options.linesch = 0;
n = 20;
A = -gallery('grcar', n); % note the minus sign
epsln = 1e-3;
fprintf('Negative Grcar Matrix\n')
fprintf(' first run original version (no line search) with each of 3 ways to represent A (dense, sparse, function handle)\n', n)
% although the matrix is banded, it is stored as a dense matrix so psapsr
% uses eig
fprintf('\ndense representation\n')
[f, x, y, z, info, xrec, yrec, zrec] = psapsr(A, epsln, mod, options);
fprintf('hit any key to continue\n')
pause
A = sparse(A); % make A a sparse matrix, so psapsr uses eigs
fprintf('\nsparse representation\n')
[f, x, y, z, info, xrec, yrec, zrec] = psapsr(A, epsln, mod, options);
fprintf('hit any key to continue\n')
pause
save A A % save the matrix in a file for testing purposes
Afun = @(p,t)amult(p,t); % function handle: this is just as a test, as
                         % Afunp loads A from A.mat for each matrix vector
                         % multiply which is very costly, but in other
                         % applications this is a useful way to code A and
                         % for this reason it is supported by "eigs"
options.x0 = zeros(length(A), 1); % to tell psapsr what n is
fprintf('\nfunction handle representation\n')
[f, x, y, z, info, xrec, yrec, zrec] = psapsr(Afun, epsln, mod, options);
fprintf('hit any key to continue\n')
pause
% now demo the local error results
fprintf('\nnow demo the local error results: note the predicted values are verified on the NEXT line\n')
localerror_demo(A, epsln)
fprintf('hit any key to continue\n')
pause
%
% now switch to the version with the line search
options.linesch = 1;
A = full(A); % go back to dense representation
fprintf('\nnow using the line search\n')
[f, x, y, z, info, xrec, yrec, zrec] = psapsr(A, epsln, mod, options);
fprintf('hit any key to continue\n')
pause
% now Mert's pathological example
load pathetic_A
options = rmfield(options, 'x0'); 
epsln=0.00176;
fprintf('\nMert''s Pathological Example: with no line search, abscissa algorithm fails (cycles)\n')
options.linesch = 0; % abscissa algorithm fails on this example
[f, x, y, z, info, xrec, yrec, zrec] = psapsr(A, epsln, mod, options);
fprintf('hit any key to continue\n')
pause
options.linesch = 1; % works brilliantly!
options.maxit = 100; % needs more time
fprintf('\nbut with a line search works brilliantly!\n')
[f, x, y, z, info, xrec, yrec, zrec, trec] = psapsr(A, epsln, mod, options);
fprintf('line search steps\n')
trec
fprintf('in abscissa case, final f is correct to 7 digits\n')
f
fprintf('hit any key to continue\n')
pause
%
% now the RD-Brusselator, a real sparse problem
n = 3200;  % or 800
options.linesch = 1;
options.maxit = 30;
A=rdbrusselator_demo(n);
epsln = 0.01;
fprintf('RD-Brusselator\n')
[f, x, y, z, info, xrec, yrec, zrec, trec, cpurec] = psapsr(A, epsln, mod, options);
fprintf('line search steps\n')
trec
fprintf('CPU time for each iteration\n')
cpurec'
epsln = 1;
fprintf('RD-Brusselator\n')
[f, x, y, z, info, xrec, yrec, zrec, trec, cpurec] = psapsr(A, epsln, mod, options);
fprintf('line search steps\n')
trec
fprintf('CPU time for each iteration\n')
cpurec'
