function [rvals, rhovals, svals] = checkconvrate(A, mod, epsvals, fig)
n = length(A);
I = eye(n);
% investigate theoretical convergence rate r as a function of eps
for j=1: length(epsvals)
    eps = epsvals(j);
    [f, x, y, z]=psapsr(A,eps,mod);
    rho = 1/abs(y'*x);
    rhovals(j) = rho;
    [U, S, V] = svd(A - z*I);
    sigsecond = S(n-1, n-1);
    svals(j) = sigsecond;
    r = 4*rho^2*eps/sigsecond;
    rvals(j) = r;
end
if fig > 0
    figure(fig)
    loglog(epsvals,rvals,'*-',epsvals,rhovals,'ro-',epsvals,svals,'mx-')
    legend('rvals', 'rhovals', 'svals')
    xlabel('epsln')
    title('conv rate r, rho=1/|y''x| and 2nd smallest singular value')
end