function [eigstr, nactual, spar, f, imagangle, fcc, iters, maxinnersteps, r] = psapsr_eigtool_dense_examples(n, epsln, mod, prtlevel)
% run through the dense eigtool examples
% set mod=0 for abscissa, mod=1 for radius
if nargin < 3
    mod = 0;
end
if nargin < 4
    prtlevel = 2;
end
fprintf('eigtool dense examples, n=%d, epsln=%g, mod=%d\n', n, epsln, mod)
densenames = eigtool_example_names;
% for pspa_2way, pspr_2way, eigtool versions
% no longer needed: eigtool 2009 is in path
% addpath('C:\Documents and Settings\pcsupprt\My Documents\MatlabOthers\eigtool2007\eigtoollib\num_comp\pseudo_abscissa')
% addpath('C:\Documents and Settings\pcsupprt\My Documents\MatlabOthers\eigtool2007\eigtoollib\num_comp\pseudo_radius')
for k=1: length(densenames)
    name = strcat(densenames{k})
    if strcmp(name, 'boeing_O')  % boeing original
        eigstr{k} = sprintf('boeing(''O'')'); % no size input
        A = boeing_demo('O'); 
    elseif strcmp(name, 'boeing_S') % boeing stabilized
        eigstr{k} = sprintf('boeing(''S'')');
        A = boeing_demo('S');
    elseif strcmp(name, 'companion')
        eigstr{k} = sprintf('companion(10)');
        A = companion_demo(10); % largest entry of n by n matrix is around n!
    elseif strcmp(name, 'demmel')
        eigstr{k} = sprintf('demmel(10)'); % initial matrix has multiple evalue: very slow for large n
        A = demmel_demo(10); 
    elseif strcmp(name, 'gaussseidel_C')  % classic
        eigstr{k} = sprintf('gaussseidel({%d, ''C''})', n);
        A = gaussseidel_demo({n, 'C'});
    elseif strcmp(name, 'gaussseidel_D') % downwind
        eigstr{k} = sprintf('gaussseidel({%d, ''D''})', n);
        A = gaussseidel_demo({n, 'D'});  
    elseif strcmp(name, 'gaussseidel_U') % updwind
        eigstr{k} = sprintf('gaussseidel({%d, ''U''})', n);
        A = gaussseidel_demo({n, 'U'});
    else
        eigstr{k} = sprintf('%s(%d)', densenames{k}, n);
        A = feval(strcat(name,'_demo'), n);
    end
    nact = length(A); % actual dimension
    nactual(k) = nact;
    options.maxit = 1000;
    options.prtlevel = prtlevel;
    [f(k), x, y, z, info, xrec, yrec, zrec, trec] = psapsr(A, epsln, mod, options);
    % compute r, the upper bound in the convergence theorem
    singvals = svd(A - z*eye(nact));
    rho = 1/abs(y'*x); % real except rounding error in abscissa case, but not in radius case
    r(k) = 4*rho^2*epsln/singvals(nact - 1);
    if ~mod
        imagangle(k) = imag(z); % imaginary part of optimal z
        spar(k) = real(zrec(1)); % spectral abscissa
    else
        imagangle(k) = angle(z); % complex argument of optimal z
        spar(k) = abs(zrec(1)); % spectral radius
    end
    iters(k) = length(zrec)-1; % not counting the initial iterate
    maxinnersteps(k) = log2(1/min(trec(2:end)));
    if ~mod
        fcc(k) = pspa_2way(A, epsln);
    else
        fcc(k) = pspr_2way(A, epsln);
    end
    if prtlevel > 0
        fnewalg = f(k)', 
        fcrisscross = fcc(k)
    end
    if abs(f(k) - fcc(k))/max([1 fcc(k)]) > 1e-4
        fprintf(' Significant discrepency between results for new alg %g and crisscross %g\n', f(k), fcc(k))
    end
    if prtlevel > 1
        fprintf('press any key to continue\n')
        pause
    end
end

