function localerror_demo(A, epsln)
% based on Nicola's code localerror.m and my code localerror2.m 
% updated November 2010 to use new psapsr code and to correct notational
% errors which led to confusion of a factor of epsln

% These confirm Theorem 5.3 and Corollary 5.4 of the paper

options.linesch = 0;  % turn off line search
[f, x, y, z, info, xrec, yrec, zrec] = psapsr(A, epsln, options);
itmax = length(zrec);
zopt =zrec(itmax);
xopt = xrec(:,itmax);
yopt = yrec(:,itmax);
n=length(A);
I=eye(n);
Bopt = A + epsln*yopt*xopt';
G = groupinv(Bopt - zopt*I);
% now look at errors at every step of iteraton
fprintf(' k   actual real(edif)     actual imag(edif)      pred next imag(edif)     ||actual E||      ||pred next E||\n')
ytxopt = yopt'*xopt;
for k = 2:itmax-1
     % all of the following correspond to index k in the paper
     B = A + epsln*yrec(:,k-1)*xrec(:,k-1)';
     % first the analysis of the error matrix
     E = B - Bopt;
     beta = xopt'*G*E*xopt;
     gamma = yopt'*E*G*yopt;
     term1 = epsln*real(gamma+beta)*yopt*xopt';
     term2 = -epsln*yopt*xopt'*E'*G';
     term3 = -epsln*G'*E'*yopt*xopt';
     Enextpred = term1 + term2 + term3;
     % now the analysis of the eigenvalue error
     z = zrec(k); % eigenvalue of B
     zdifact = z - zopt;
     imagzdifnextpred = epsln*(imag(beta + gamma))/ytxopt;
     fprintf(' %d    %e        %e          %e        %e        %e   \n',  ...
         k, real(zdifact), imag(zdifact), imagzdifnextpred, norm(E), norm(Enextpred))
end