function [G, P] = groupinv(A, tol)
% returns G, the group inverse of A, for case of nullity one or zero
% this is the unique matrix satisfying AGA=A, GAG=G and AG=GA.
% ref: Meyer and Stewart, SINUM, 1988
% aka reduced resolvent (Kato)
if nargin < 2
    tol = 1e-6;
end
n = length(A);
[U,S,V] = svd(A);
s = diag(S);
if s(n) > tol
    G = V*diag(1./s)*U';
    return
end
if n > 2 & s(n-2) < tol
    error('groupinv does not handle nullity > 1')
else
   y=-U(:,n); 
   x= V(:,n);
   ytx = y'*x; 
   % following is essential if ytx is complex
   y = exp(i*angle(ytx))*y;  % now y'x is positive and real
   ytx = y'*x;
   z = y/ytx;  % so z'x = 1
%    gamma=y'*x; 
%    z=y/gamma;
   Uhat=U(:,1:n-1); Vhat=V(:,1:n-1); Shat=S(1:n-1,1:n-1);
   P=[Uhat,x]; % note: NOT orthogonal
   I = eye(n);
   Pinv=[Uhat'*(I-x*z'); z'];
   C=Uhat'*A*Uhat;
   G=P*[inv(C),zeros(n-1,1);zeros(1,n)]*Pinv; % group inverse
end