function [x,y] = rpcompatible(x,y,theta)
% scale y so that the pair x,y is RPZ-compatible with respect to theta, 
% that is ||x||=||y||=1 and y'*x is a real, positive multiple of 
% exp(i*theta):

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  PSAPSR 1.01 Copyright (C) 2011 Nicola Guglielmi, Michael Overton
%%  This program is free software: you can redistribute it and/or modify
%%  it under the terms of the GNU General Public License as published by
%%  the Free Software Foundation, either version 3 of the License, or
%%  (at your option) any later version.
%%
%%  This program is distributed in the hope that it will be useful,
%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%  GNU General Public License for more details.
%%
%%  You should have received a copy of the GNU General Public License
%%  along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if nargin < 3
    theta = 0;
end
x = x/norm(x);
y = y/norm(y);
ytx = y'*x; 
if theta == 0 & isreal(ytx)
    % avoid imaginary rounding error
    if ytx < 0
        y = -y; 
    end
elseif theta == -pi & isreal(ytx)
    % no tolerance: if z was negative real, theta is -pi to full precision
    % avoid imaginary rounding error
    if ytx > 0
        y = -y;
    end
else
    y = exp(i*(angle(ytx) - theta))*y; 
end