function q = aplusuvt(A, Atype, scalefac, u, v, transpose, p)
% if transpose == 0, return q = B*p = (A + scalefac*u*v')*p
% if transpose == 1, return q = transpose(B)*p = B.'*p = (A.' + scalefac*conj(v)*u.'))*p 
% *not* the conjugate transpose B'*p = (A' + scalefac'*v*u')*p
% scalefac is a scalar, u and v are column vectors
% if Atype == 2, A is a sparse matrix
% if Atype == 3, A is a function handle for a routine to compute A*p or transpose(A)*p

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  PSAPSR 1.01 Copyright (C) 2010 Nicola Guglielmi, Michael Overton
%%  This program is free software: you can redistribute it and/or modify
%%  it under the terms of the GNU General Public License as published by
%%  the Free Software Foundation, either version 3 of the License, or
%%  (at your option) any later version.
%%
%%  This program is distributed in the hope that it will be useful,
%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%  GNU General Public License for more details.
%%
%%  You should have received a copy of the GNU General Public License
%%  along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if transpose == 0
    vtp = v'*p;
    s = scalefac*vtp;
    if Atype == 2
        q = A*p + s*u;
    else
        q = A(p,0) + s*u;
    end
else % transpose, *not* conjugate transpose
    utp = u.'*p;
    s = scalefac*utp;
    if Atype == 2
        q = A.'*p + s*conj(v);
    else
        q = A(p,1) + s*conj(v);
    end
end
    