function [u,v,c,s]=numrange(u1,u2,v1,v2,singvaldif,mu,prtlevel)
% function [u,v,c,s]=numrange(u1,u2,v1,v2)
%
%  Input: unit vectors u1, u2, v1, v2 
% 
%  Find a combination u = c*u1 + s*u2 and v = c*v1 + s*v2
%  such that v'*u == 0, that is, [c; s]' M [c; s] = 0,
%  where M = [v1 v2]'*[u1 u2], that is, 0 is in the
%  numerical range of M.  It is required that the initital
%  u1, u2, v1, v2 satisfy  mu*(v1'*u1) + (1-mu)*(v2'*u2) == 0
%  for some mu in [0, 1], and that u1 is orthogonal to u2 and that
%  v1 is orthogonal to v2
%
%  Written by R. Byers, modified by M. Overton

%  In fact, WHEN THERE IS A DOUBLE SINGULAR VALUE, IT
%  turns out that, as we suspected back in 2004,
%  c = sqrt(mu) and s = sqrt(1-mu).  This choice clearly
%  works when u1'v2 + u2'v1 = 0, so we use this rule in that
%  case, but in fact it seems to always hold.

%  skip input check since called by newtonsaddle
%  also skip tolerance checks since these are tricky and the best
%  recovery is to proceed anyway

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  NEARDEFMAT 1.0 Copyright (C) 2010  Michael Overton
%%  This program is free software: you can redistribute it and/or modify
%%  it under the terms of the GNU General Public License as published by
%%  the Free Software Foundation, either version 3 of the License, or
%%  (at your option) any later version.
%%
%%  This program is distributed in the hope that it will be useful,
%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%  GNU General Public License for more details.
%%
%%  You should have received a copy of the GNU General Public License
%%  along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

M = [v1 v2]'*[u1 u2];
if abs(M(1,1)) < 100*eps
    u = u1;
    v = v1;
    if prtlevel > 2
        fprintf('setting u to u1, v to v1\n')
    end
    return
elseif abs(M(2,2)) < 100*eps
    u = u2;
    v = v2;
    if prtlevel > 2
        fprintf('setting u to u2, v to v2\n')
    end
    return
end
% check to see if the "mu rule" is applicable: we expect that it always is,
% in the nonsmooth case, but we don't have a proof, but anyway, because
% of rounding and the consequent transition between the smooth and
% nonsmooth cases, the mu rule won't always work and we really need the 0
% in the numerical range calculation
if abs(M(1,2) + M(2,1)) < 100*eps
    % just use the mu rule
    c = sqrt(mu);
    s = sqrt(1 - mu);
    u = c*u1 + s*u2;
    v = c*v1 + s*v2;
    if prtlevel > 2
        fprintf(' using the mu law to construct u and v\n')
    end
    return
end
if prtlevel > 2
    fprintf(' Constructing u and v from the 0 in the FoV computation\n')
end
% in the smooth case, M(2,2) should be small but maybe not as small as the
% tolerance used above.  In that case this should compute something close
% to c=0, s=1, but not exactly.  
% in the nonsmooth case, the mu law above should work in most cases, but
% again maybe not in every case. The following should cover all cases.
%%%% Make diagonal entries real by scaling M %%%%
if abs(M(1,1))>abs(M(2,2))  % fails if both are 0
    om = M(1,1)/abs(M(1,1)) ;   
else
    om = M(2,2)/abs(M(2,2));
end
M = conj(om)*M;
%%%% Make sum of off diagonal imaginary parts cancel 
%    by conjugation by diag([1 om2]). This give arg(s) %%%%
a = imag(M(1,2))+imag(M(2,1));
if abs(a) < 50*eps % actually no need to make this check
    % other rule gives om2 = 1 or -1, which are both fine
    om2 = 1;
else
    b = real(M(1,2))-real(M(2,1));
    ct=b/norm([a b]); st = -a/norm([a b]);
    om2 = ct + sqrt(-1)*st;
    M(1,2) = M(1,2)*om2;
    M(2,1) = M(2,1)*conj(om2);
end
%%%% now, only the real part counts %%%%
M = real(M);
%%%% do zero in *real* numerical range calculation %%%%
if M(1,2) + M(2,1) < 0
    M = -M; 
end
% solve the quadratic equation M11 + t(M12+M21) + t^2 M22 = 0
% Ralph inverted this, solving instead (1/t)^2 M11 + (1/t)(M12+M21) + M22 = 0
% and inverting the result, not sure why
t = -2*M(1,1)/(M(1,2)+M(2,1)+sqrt((M(1,2)+M(2,1))^2-4*M(1,1)*M(2,2)));
% the following is equivalent, but notice that we need to use the opposite
% sign for the sqrt: looks like we haven't, but that's because Ralph put a
% minus sign in the numerator
tMLO = (-(M(1,2)+M(2,1)) + sqrt((M(1,2)+M(2,1))^2 - 4*M(1,1)*M(2,2)))/(2*M(2,2));
% the other root is the same magnitude but with a minus sign (they are both real)
tMLO2 = (-(M(1,2)+M(2,1)) - sqrt((M(1,2)+M(2,1))^2 - 4*M(1,1)*M(2,2)))/(2*M(2,2));
c = 1/sqrt(1+t*t);
s = c*t*om2;
u = c*u1 + s*u2;
v = c*v1 + s*v2;
if any(isnan(u))|any(isnan(v))
    fprintf('numrange: u or v contains a nan. This should not happen\n')
    fprintf('Send email to overton@cs.nyu.edu with subject header neardefmat')
    return
end
% temptol = 1e-12;
% if singvaldif < temptol & (abs(c + sqrt(mu)) < temptol | abs(c - sqrt(mu)) < temptol) & ...
%   abs(M(1,2)+M(2,1)) > temptol
%     fprintf('the mu-law works even though u1''v2 + u2''v1 is not close to 0\n')
%     keyboard
% end
