function neardefmatfinish(B)
% finish up with some printing eigenvalues and their condition numbers
% for the constructed matrix B that should be numerically defective

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  NEARDEFMAT 1.0 Copyright (C) 2010  Michael Overton
%%  This program is free software: you can redistribute it and/or modify
%%  it under the terms of the GNU General Public License as published by
%%  the Free Software Foundation, either version 3 of the License, or
%%  (at your option) any later version.
%%
%%  This program is distributed in the hope that it will be useful,
%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%  GNU General Public License for more details.
%%
%%  You should have received a copy of the GNU General Public License
%%  along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[evecB,evalB,p] = condeig(B);
evalB = diag(evalB);
n = length(B);
eigdif = inf*ones(n);
for i=1:n
    for j=1:i-1
        eigdif(i,j) = abs(evalB(i)-evalB(j));
    end
end
[d, i, j] = matrixmin(eigdif);
% prtlevel checked before calling this routine
fprintf('neardefmat: two closest computed eigenvalues of B differ by %g\n',d)
fprintf(' and condition numbers of these eigenvalues are %g, %g\n', p(i), p(j))