function [f, g, H] = fgh_sigma_general(U, S, V, j)
% [f, g, H] = fgh_sigma_general(U, S, V, j)
% gradient and Hessian of f(x,y) = sigma_j(A - (x+iy)I),
% where A-zI = A-(x+iy)I = U S V'
% formula from J-G Sun, J Comp Math, 1988, as transcribed by Ralph,
% and further simplified subsequently.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  NEARDEFMAT 1.0 Copyright (C) 2010  Michael Overton
%%  This program is free software: you can redistribute it and/or modify
%%  it under the terms of the GNU General Public License as published by
%%  the Free Software Foundation, either version 3 of the License, or
%%  (at your option) any later version.
%%
%%  This program is distributed in the hope that it will be useful,
%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%  GNU General Public License for more details.
%%
%%  You should have received a copy of the GNU General Public License
%%  along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n = length(S);
f = S(j,j);
if f == 0 % cannot happen unless z is an eigenvalue
    f = eps;
end
u = U(:,j);
v = V(:,j);
g = zeros(2,1);
g(1) = - real(u'*v);
g(2) = imag(u'*v); % equivalently, -imag(v'*u)
if nargout < 3
    return
end
% set R to pseudoinverse of f^2 - S^2, without any tolerances
s = diag(S);
r = 1./(f*f - s.^2); 
indx = find(r == inf); % usually just j
if length(indx) > 1
    fprintf('**** exactly multiple singular values, setting quotient to 0 instead of inf\n')
    % keyboard
end
r(indx) = 0; 
R = diag(r);
Utv = U'*v;
Vtu = V'*u;
% notationally, D is the pseudoinverse of f^2 - (A-zI)'*(A-zI) and
% E is the pseudoinverse of f^2 - (A-zI)*(A-zI)'
utDu = Vtu'*R*Vtu;
vtEv = Utv'*R*Utv;
term1 = f*(utDu + vtEv); % real but may have imag rounding
term2 = 2*Utv'*S*R*Vtu;  % complex
H(1,1) = real(term1) + real(term2) + g(2)^2/f;
H(1,2) = imag(term2) - g(1)*g(2)/f;
H(2,1) = H(1,2);
H(2,2) = real(term1) - real(term2) + g(1)^2/f;