function [lowerbnd,upperbnd] = wilkbds(x, d, s, normA)
% lower and upper "Wilkinson" bounds on distance to nearest defective matrix
% written by S. Bora, modified by M. Overton
% x, d and s are output of condeig(A): matrix of right eigenvectors,
% diagonal matrix of eigenvalues, and vector of condition number reciprocals
%ub4 changed by sb to conform with tofna paper on 17/5/08 in Zurich

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  NEARDEFMAT 1.0 Copyright (C) 2010  Shreemayee Bora and Michael Overton
%%  This program is free software: you can redistribute it and/or modify
%%  it under the terms of the GNU General Public License as published by
%%  the Free Software Foundation, either version 3 of the License, or
%%  (at your option) any later version.
%%
%%  This program is distributed in the hope that it will be useful,
%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%  GNU General Public License for more details.
%%
%%  You should have received a copy of the GNU General Public License
%%  along with this program.  If not, see <http://www.gnu.org/licenses/>.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
n = length(d);
% normalize the right eigenvectors first
for j=1:n
    x(:,j) = x(:,j)/norm(x(:,j));
end
% compute normalized left eigenvectors 
y = inv(x)';
for j= 1:n,
        y(:,j) = y(:,j)/norm(y(:,j));
end
d = diag(d);

% Compute ub1 = min ( norm(A)/sqrt(s(i)^2-1) )
% or, as in neardefmat: wilkbnd = normA*s/sqrt(1 - s^2);   
for i = 1:n
    tmp(i) = 1/sqrt(s(i)^2 -1);
end

ub(1) = normA * min(tmp);  % Wilkinson's bound

%compute other bounds

U2 = inf*ones(n); U3 = U2; U4 = U2; 
L1= inf*ones(n); L2 =L1; L3 = L1; L4 = L1; % note: take min below, not max

for i=2:n
    for j= 1:i-1
        sep = abs(d(i)-d(j)); 
        phi =abs(x(:,i)'*x(:,j)); % normalization was done above
        psi =abs(y(:,i)'*y(:,j));
%   see p.10 of TOFNA paper - much too expensive to compute like this!
%         condij = norm((x(:,i)*y(:,i)')/(y(:,i)'*x(:,i)) + ...
%             (x(:,j)*y(:,j)')/(y(:,j)'*x(:,j)));
%       qij = max(s(i),s(j))/condij;
%       opt = s(i)+sqrt(s(i)^2-1)+s(j)+sqrt(s(j)^2-1);
        
        %compute ratios for upperbounds
        
        U2(i, j) = (sep/2)* sqrt( (1-phi)/(1+phi) ); % see p.8 of TOFNA paper
        U3(i, j) = (sep/2)* sqrt( (1-psi)/(1+psi) ); % same thing but for left evectors
%       U4(i, j) = sep/(2*qij);                          % see p.10 of TOFNA paper
        
        %compute ratios for lower bounds
        
        L1(i, j) = sep/(2*sum(s));   % another Wilkinson bound, see p.15 of TOFNA
        L2(i, j) = sep/(n*(s(i) + s(j))); % Demmel bound, see p.20 of TOFNA
%       we don't include the bounds JD and AB on p.19 because they are too 
%       expensive to compute - the comments at the bottom of p.19 of TOFNA suggest at 
%       first that they are also unreliable, but what RA means is that they may
%       not be sharp
%    
%       L3 and L4 were previously included below, but they are not bounds, they are
%       just approximations and so are commented out
%         L3(i, j) = sep/(2* cnd); 
%         only an approximation, not a bound, so we don't include it
%         L4(i, j) = sep/opt;       % these bounds may not be reliable
    end
end

% compute the bounds 

ub(2) = min(min(U2)); ub(3) = min(min(U3)); %  ub(4) = min(min(U4));
upperbnd = min(ub(1:3)); % best upper bound
% we need to first take MIN over the i,j quantities
lb(1) = min(min(L1)); lb(2) = min(min(L2)); % lb(3) = min(min(L3)); lb(4) = min(min(L4));
lowerbnd = max(lb(1:2)); % best lower bound
% fprintf('lower bounds are %g, %g and upper bounds are %g %g %g\n', lb, ub)




        
        