function name = objname(obj, pars)
% return a string associated with objective obj
% pars.epsilon is needed if obj is 'p'
switch obj
    case 'h'
        name = 'H-infinity performance';
    case 'r'
        name = 'inverse of complex stability radius';
    case 's'
        name = 'spectral abscissa';
    case '+'
        name = 'stabilize only';
    case 'p'
        name = sprintf('%g-pseudospectral abscissa', pars.epsilon);
    otherwise
        name = [];
end