function [order,init,obj,options] = hifooinputcheck(inputs)
% This function processes and returns arguments of the following classes
% - order is a nonnegative integer
% - init is either a structure with fields A,B,C,D or an SS object
% - obj is a char
% - options is a structure with no required fields
% The input arguments can be given in arbitrary order
order = [];
init = [];
obj = [];
options = [];
for k = 1:length(inputs)
    arg = inputs{k};
    % the additional 1 is because plant is always the first arg to hifoo
    errstr = strcat('hifoo: Input argument #',int2str(k) + 1);
    switch class(arg)
        case 'struct' % [] is not a struct, it's a double, see below
            % d field is required, although a, b, c fields could be empty
            if isfield(arg, 'd')|isfield(arg,'D')|isfield(arg,'Dhat') 
                if isempty(init) % i.e., init not already assigned
                    init = arg; 
                else % 2nd struct of this kind not allowed
                    error(strcat(errstr, ' is not valid'))
                end
            else
                if isempty(options) % i.e., options not already assigned
                    options = arg; % fields checked in hifoomain
                else % 2nd unrecognized structure not allowed
                    error(strcat(errstr, ' is not valid'))
                end
            end
        case 'char'
            if isempty(obj) % i.e., obj not already assigned
                obj = lower(arg); % convert to lower case
            else % 2nd char not allowed
                error(strcat(errstr, ' is not valid'))
            end 
            switch obj
                case {'h','r','s','p','+'}
                    % nothing
                otherwise
                    error(strcat(errstr, ' is a char but is not a valid objective(h, r, s, p, or +)'))
            end
        case 'double'
            if isempty(arg) % [] is a double
                % ignore []
            else
                if isempty(order) % i.e., order not already assigned
                    order = arg;
                else % 2nd nonempty double not allowed
                    error(strcat(errstr, ' is not valid'))
                end 
                if ~isnonnegint(order)
                    error(strcat(errstr, ' is a double but is not a valid order (nonnegative integer)'))
                end
            end
        case 'ss'
            if isempty(init) % i.e., init not already assigned
                init = arg; % converted to struct in hifoo
            else
                error(strcat(errstr, ' is not valid'))
            end
        otherwise
            error(strcat(errstr, ' is not valid'))
    end
end
if isempty(order)
    order = 0; % default (static output feedback)
end
if isempty(obj)
    obj = 'h'; % default (H-infinity performance)
end
% init and options are allowed to be empty


