function [Abig, Bbig, Cbig, Dbig] = ...
    getABCDbig(A, B1, B2, C1, C2, D11, D12, D21, nhat, x)
% construct state space representation for general reduced-order controller
% A, B1, B2, C1, C2, D11, D12, D21 are fixed matrices
% nhat is the order of the controller
% the vector x encodes the variables Ahat, Bhat, Chat, Dhat (Ahat has
% dimension nhat by nhat, and static output feedback is the case nhat=0)
% it's tacitly assumed for that D22 = 0 so everything is linear
% for the derivatives, see chainABCD
%
% first decode Ahat, Bhat, Chat, Dhat from x
m = size(B2,2);
p = size(C2,1);
[Ahat, Bhat, Chat, Dhat] = getABCDhat(nhat, m, p, x);

Abig = [A + B2*Dhat*C2    B2*Chat      % (n + nhat) by (n + nhat)
        Bhat*C2           Ahat    ];
Bbig = [B1 + B2*Dhat*D21               % (n + nhat) by m1
        Bhat*D21         ];
Cbig = [C1 + D12*Dhat*C2   D12*Chat];  % p1 by (n + nhat)
Dbig = D11 + D12*Dhat*D21;             % p1 by m1